/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.SkillEvent;
import de.teamlapen.vampirism.client.core.RegistryManagerClient;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModVillages;
import de.teamlapen.vampirism.core.VampirismRegistries;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolderRegistry;

public class RegistryManager
implements IInitListener {
    @SideOnly(value=Side.CLIENT)
    private static RegistryManagerClient registryManagerClient;

    @SideOnly(value=Side.CLIENT)
    public static void setupClientRegistryManager() {
        registryManagerClient = new RegistryManagerClient();
        MinecraftForge.EVENT_BUS.register((Object)registryManagerClient);
    }

    @SideOnly(value=Side.CLIENT)
    public static RegistryManagerClient getRegistryManagerClient() {
        return registryManagerClient;
    }

    @SubscribeEvent
    public void onBuildRegistries(RegistryEvent.NewRegistry event) {
        VampirismRegistries.init();
    }

    @Override
    public void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        switch (step) {
            case INIT: {
                ModBlocks.registerCraftingRecipes();
                ModItems.registerCraftingRecipes();
                ModItems.registerBloodConversionRates();
                ModVillages.init();
                ModAdvancements.registerAdvancements();
                ModParticles.init();
                break;
            }
            case PRE_INIT: {
                ModFluids.registerFluids();
                ModEntities.registerConvertibles();
                ModEntities.registerCustomExtendedCreatures();
                break;
            }
            case POST_INIT: {
                if (!ModPotions.checkNightVision()) break;
                ModPotions.fixNightVisionPotionTypes();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onMissingMappingsEntity(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getMappings()) {
            ModEntities.fixMapping((RegistryEvent.MissingMappings.Mapping<EntityEntry>)m);
        }
    }

    @SubscribeEvent
    public void onMissingMappingsBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getMappings()) {
            ModBlocks.fixMapping((RegistryEvent.MissingMappings.Mapping<Block>)m);
        }
    }

    @SubscribeEvent
    public void onMissingMappingsItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getMappings()) {
            if (ModItems.fixMapping((RegistryEvent.MissingMappings.Mapping<Item>)m)) continue;
            ModBlocks.fixMappingItemBlock((RegistryEvent.MissingMappings.Mapping<Item>)m);
        }
    }

    @SubscribeEvent
    public void onMissingMappingsPotion(RegistryEvent.MissingMappings<Potion> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getMappings()) {
            ModPotions.fixMapping((RegistryEvent.MissingMappings.Mapping<Potion>)m);
        }
    }

    @SubscribeEvent
    public void onMissingMappingsSkill(RegistryEvent.MissingMappings<ISkill> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getMappings()) {
            VampireSkills.fixMapping((RegistryEvent.MissingMappings.Mapping<ISkill>)m);
        }
    }

    @SubscribeEvent
    public void onMissingMappingsSoundEvent(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping m : event.getMappings()) {
            m.ignore();
        }
    }

    @SubscribeEvent
    public void onRegisterActions(RegistryEvent.Register<IAction> event) {
        VampireActions.registerDefaultActions((IForgeRegistry<IAction>)event.getRegistry());
        HunterActions.registerDefaultActions((IForgeRegistry<IAction>)event.getRegistry());
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    @SubscribeEvent
    public void onRegisterEntityActions(RegistryEvent.Register<IEntityAction> event) {
        EntityActions.registerDefaultActions((IForgeRegistry<IEntityAction>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerBiomes((IForgeRegistry<Biome>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterEnchantments(RegistryEvent.Register<Enchantment> event) {
        ModEnchantments.registerEnchantments((IForgeRegistry<Enchantment>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterEntities(RegistryEvent.Register<EntityEntry> event) {
        ModEntities.registerEntities((IForgeRegistry<EntityEntry>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        ModItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterPotions(RegistryEvent.Register<Potion> event) {
        ModPotions.registerPotions((IForgeRegistry<Potion>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterProfessions(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        ModVillages.registerProfessions((IForgeRegistry<VillagerRegistry.VillagerProfession>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterRecipe(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.registerRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterSkills(RegistryEvent.Register<ISkill> event) {
        HunterSkills.registerHunterSkills((IForgeRegistry<ISkill>)event.getRegistry());
        VampireSkills.registerVampireSkills((IForgeRegistry<ISkill>)event.getRegistry());
    }

    @SubscribeEvent
    public void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public void onSkillNodeCreated(SkillEvent.CreatedNode event) {
        if (event.getNode().isRoot()) {
            if (event.getNode().getFaction().equals(VReference.HUNTER_FACTION)) {
                HunterSkills.buildSkillTree(event.getNode());
            } else if (event.getNode().getFaction().equals(VReference.VAMPIRE_FACTION)) {
                VampireSkills.buildSkillTree(event.getNode());
            }
        }
    }
}

