/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.math.Vec3d;

public class SpeedEntityAction<T extends EntityCreature>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public static final UUID UUIDS = UUID.fromString("2b49cf70-b634-4e85-8c3e-0147919eaf54");

    public SpeedEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public int getDuration(int level) {
        return Balance.ea.SPEED_DURATION * 20;
    }

    @Override
    public int getCooldown(int level) {
        return Balance.ea.SPEED_COOLDOWN * 20;
    }

    @Override
    public void deactivate(T entity) {
        ((IFactionEntity)entity).getRepresentingEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_188479_b(UUIDS);
    }

    @Override
    public void onUpdate(T entity, int duration) {
        if (!((IFactionEntity)entity).getRepresentingEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_180374_a(new AttributeModifier(UUIDS, "speedaction", Balance.ea.SPEED_AMOUNT, 2))) {
            ((IFactionEntity)entity).getRepresentingEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUIDS, "speedaction", Balance.ea.SPEED_AMOUNT, 2));
        }
        if (duration % 5 == 0) {
            VampLib.proxy.getParticleHandler().spawnParticles(entity.func_130014_f_(), ModParticles.CLOUD, ((EntityCreature)entity).field_70165_t, ((EntityCreature)entity).field_70163_u, ((EntityCreature)entity).field_70161_v, 5, 0.5, entity.func_70681_au(), -((EntityCreature)entity).field_70159_w, 0.0, -((EntityCreature)entity).field_70179_y);
        }
    }

    @Override
    public void activate(T entity) {
    }

    @Override
    public void updatePreAction(T entity, int duration) {
    }

    @Override
    public int getWeight(T entity) {
        double distanceToTarget = new Vec3d(((EntityCreature)entity).field_70165_t, ((EntityCreature)entity).field_70163_u, ((EntityCreature)entity).field_70161_v).func_178786_a(entity.func_70638_az().field_70165_t, entity.func_70638_az().field_70163_u, entity.func_70638_az().field_70161_v).func_72433_c();
        if (distanceToTarget > 10.0) {
            return 3;
        }
        if (distanceToTarget > 5.0) {
            return 2;
        }
        return 1;
    }
}

