/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.special;

import com.google.common.base.Optional;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.EntityAreaParticleCloud;
import de.teamlapen.vampirism.entity.EntityVampirism;
import de.teamlapen.vampirism.util.HalloweenSpecial;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDraculaHalloween
extends EntityVampirism {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDraculaHalloween.class, (DataSerializer)DataSerializers.field_187203_m);
    private int seen = 0;
    private int hiding = 0;
    private boolean particle = false;

    public EntityDraculaHalloween(World world) {
        super(world);
        this.func_184224_h(true);
    }

    public boolean func_70067_L() {
        return false;
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    public boolean isParticle() {
        return this.particle;
    }

    public void setParticle(boolean particle) {
        this.particle = particle;
    }

    public void makeHide(int time) {
        this.seen = 0;
        this.func_82142_c(true);
        BlockPos spawn = this.field_70170_p.func_175694_M();
        this.func_70107_b(spawn.func_177958_n(), 3.0, spawn.func_177952_p());
        this.hiding = time;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!HalloweenSpecial.isEnabled()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            EntityLivingBase owner = this.getOwner();
            if (owner != null && !this.func_82150_aj() && !((EntityPlayer)owner).func_175144_cb()) {
                this.func_82142_c(true);
                VampirismMod.log.t("Setting invisible on other client", new Object[0]);
            }
            return;
        }
        EntityLivingBase owner = this.getOwner();
        if (owner == null) {
            this.func_70106_y();
            return;
        }
        if (this.func_130014_f_().func_72935_r()) {
            if (this.hiding == 0) {
                this.makeHide(this.func_70681_au().nextInt(1000));
            }
            return;
        }
        if (this.hiding == 0) {
            if (UtilLib.canReallySee(owner, (EntityLivingBase)this, true)) {
                ++this.seen;
                if (this.seen == 1 && owner instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)owner).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(ModSounds.entity_vampire_scream, SoundCategory.NEUTRAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, 1.0f));
                }
            } else if (this.func_70068_e((Entity)owner) > 5.0) {
                this.teleportBehind(owner);
            }
            if (this.seen > 5) {
                EntityAreaParticleCloud particleCloud = new EntityAreaParticleCloud(this.func_130014_f_());
                particleCloud.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                particleCloud.setRadius(0.7f);
                particleCloud.setHeight(this.field_70131_O);
                particleCloud.setDuration(3);
                particleCloud.setSpawnRate(10.0f);
                this.func_130014_f_().func_72838_d((Entity)particleCloud);
                if (this.func_70681_au().nextInt(3) == 0) {
                    this.teleportBehind(owner);
                } else if (this.func_70681_au().nextInt(3) == 0) {
                    this.func_70106_y();
                } else {
                    this.makeHide(this.func_70681_au().nextInt(3000));
                }
                this.seen = 0;
            }
        } else {
            --this.hiding;
            if (this.hiding == 0) {
                this.teleportBehind(owner);
                this.func_82142_c(false);
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70106_y();
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        return super.func_189511_e(compound);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 1.0f));
    }

    private void teleportBehind(EntityLivingBase target) {
        BlockPos behind = UtilLib.getPositionBehindEntity(target, 1.5f);
        this.func_70107_b(behind.func_177958_n(), target.field_70163_u, behind.func_177952_p());
        if (!this.func_70058_J()) {
            int y = this.func_130014_f_().func_175645_m(behind).func_177956_o();
            this.func_70107_b(behind.func_177958_n(), y, behind.func_177952_p());
        }
    }
}

