/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionPropertyRandomizer;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

class BloodPotionEffect
implements IBloodPotionEffect {
    private final String id;
    private final Potion potion;
    private final boolean isBad;
    private final IBloodPotionPropertyRandomizer propertyRandomizer;

    BloodPotionEffect(String id, Potion potion, boolean isBad, int weight, IBloodPotionPropertyRandomizer propertyRandomizer) {
        this.id = id;
        this.potion = potion;
        this.isBad = isBad;
        this.propertyRandomizer = propertyRandomizer;
    }

    @Override
    public boolean canCoexist(@Nonnull IBloodPotionEffect other) {
        if (this.isBad() != other.isBad()) {
            return true;
        }
        if (other instanceof BloodPotionEffect) {
            return !this.potion.equals(((BloodPotionEffect)other).potion);
        }
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLocName(NBTTagCompound properties) {
        return UtilLib.translate(this.potion.func_76393_a());
    }

    @Override
    public NBTTagCompound getRandomProperties(Random rng) {
        return this.propertyRandomizer.getRandomProperties(rng);
    }

    @Override
    public boolean isBad() {
        return this.isBad;
    }

    @Override
    public void onActivated(EntityLivingBase hunter, NBTTagCompound nbt, float durationMult) {
        hunter.func_70690_d(new PotionEffect(this.potion, (int)((float)nbt.func_74762_e("duration") * durationMult), nbt.func_74762_e("amplifier")));
    }

    public String toString() {
        return "BloodPotionEffect{potion=" + this.potion + ", isBad=" + this.isBad + '}';
    }
}

