/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import de.teamlapen.lib.lib.tile.InventoryTileEntity;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.lib.util.ISoundReference;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronRecipe;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronCraftingManager;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAlchemicalCauldron
extends InventoryTileEntity
implements ITickable,
ISidedInventory {
    private static final int SLOT_RESULT = 0;
    private static final int SLOT_LIQUID = 1;
    private static final int SLOT_INGREDIENT = 2;
    private static final int SLOT_FUEL = 3;
    private static final int[] SLOTS_DOWN = new int[]{0};
    private static final int[] SLOTS_SIDE = new int[]{3};
    private static final int[] SLOTS_TOP = new int[]{2, 1};
    private int totalBurnTime = 0;
    private int burnTime = 0;
    private int cookTime = 0;
    private int totalCookTime = 0;
    private boolean cookingClient;
    private boolean burningClient;
    private int liquidColor;
    @SideOnly(value=Side.CLIENT)
    private ISoundReference boilingSound;
    @Nullable
    private IAlchemicalCauldronRecipe checkedRecipe;
    private String username;
    private UUID ownerID;

    private static int getLiquidColor(ItemStack s) {
        IFluidHandler handler;
        FluidStack fluid;
        if (s != null && FluidLib.hasFluidItemCap(s) && (fluid = (handler = FluidLib.getFluidItemCap(s)).drain(10000, false)) != null) {
            return TileAlchemicalCauldron.getFluidColor(fluid);
        }
        return AlchemicalCauldronCraftingManager.getInstance().getLiquidColor(s);
    }

    private static int getFluidColor(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        if (fluid.equals(FluidRegistry.WATER)) {
            return -1070579457;
        }
        if (fluid.equals(FluidRegistry.LAVA)) {
            return -45040;
        }
        int color = fluid.getColor(stack);
        if (color == -1) {
            color = -2;
        }
        return color;
    }

    private static boolean isLiquidStack(ItemStack stack) {
        return TileAlchemicalCauldron.getLiquidColor(stack) != -1;
    }

    public TileAlchemicalCauldron() {
        super(new InventorySlot[]{new InventorySlot(item -> false, 116, 35), new InventorySlot(TileAlchemicalCauldron::isLiquidStack, 44, 17), new InventorySlot(68, 17), new InventorySlot(TileEntityFurnace::func_145954_b, 56, 53)});
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        if (direction == EnumFacing.UP && index == 2 && this.func_94041_b(1, itemStackIn)) {
            return false;
        }
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean canUse(EntityPlayer player) {
        if (HunterPlayer.get(player).getSkillHandler().isSkillEnabled(HunterSkills.basic_alchemy)) {
            if (this.isOwner(player)) {
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.vampirism.alchemical_cauldron.other", new Object[]{this.getOwnerName()}));
            return false;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("tile.vampirism.alchemical_cauldron.cannot_use", new Object[]{this.getOwnerName()}));
        return false;
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.vampirism.alchemical_cauldron.display", new Object[]{this.getOwnerName(), new TextComponentTranslation("tile.vampirism.alchemical_cauldron.name", new Object[0])});
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.totalBurnTime;
            }
            case 1: {
                return this.burnTime;
            }
            case 2: {
                return this.totalCookTime;
            }
            case 3: {
                return this.cookTime;
            }
        }
        return 0;
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLiquidColorClient() {
        return this.liquidColor;
    }

    @Nonnull
    public String func_70005_c_() {
        return "vampirism.container.alchemical_cauldron";
    }

    public String getOwnerName() {
        if (this.username == null) {
            EntityPlayer player = this.getOwner();
            if (player != null) {
                this.username = player.getDisplayNameString();
            } else {
                return "Unknown";
            }
        }
        return this.username;
    }

    @Nonnull
    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case UP: {
                return SLOTS_TOP;
            }
            case DOWN: {
                return SLOTS_DOWN;
            }
        }
        return SLOTS_SIDE;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189515_b(new NBTTagCompound());
        nbt.func_74757_a("cooking", this.cookTime > 0 && this.isBurning());
        nbt.func_74757_a("burning", this.burnTime > 0);
        nbt.func_74778_a("username", this.getOwnerName());
        ItemStack liquidItem = this.func_70301_a(1);
        if (liquidItem != null) {
            nbt.func_74782_a("liquidItem", (NBTBase)liquidItem.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(@Nonnull NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.cookingClient = nbt.func_74767_n("cooking");
        this.burningClient = nbt.func_74767_n("burning");
        if (nbt.func_74764_b("liquidItem")) {
            this.func_70299_a(1, new ItemStack(nbt.func_74775_l("liquidItem")));
        } else {
            this.func_70299_a(1, ItemStack.field_190927_a);
        }
        this.username = nbt.func_74779_i("username");
        this.liquidColor = TileAlchemicalCauldron.getLiquidColor(this.func_70301_a(1));
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public boolean isBurning() {
        if (this.field_145850_b.field_72995_K) {
            return this.burningClient;
        }
        return this.burnTime > 0;
    }

    public boolean isCooking() {
        if (this.field_145850_b.field_72995_K) {
            return this.cookingClient;
        }
        return this.cookTime > 0;
    }

    public boolean isFilled() {
        if (this.field_145850_b.field_72995_K && this.liquidColor == -1) {
            return false;
        }
        return this.isStackInSlot(1);
    }

    public boolean isOwner(EntityPlayer player) {
        if (this.ownerID != null) {
            return this.ownerID.equals(player.getPersistentID());
        }
        this.setOwner(player);
        return true;
    }

    public void markDirty(boolean sync) {
        super.func_70296_d();
        if (sync) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("burntime")) {
            this.burnTime = tagCompound.func_74762_e("burntime");
            this.cookTime = tagCompound.func_74762_e("cooktime");
            this.totalBurnTime = tagCompound.func_74762_e("cooktime_total");
        }
        if (tagCompound.func_186855_b("owner")) {
            this.ownerID = tagCompound.func_186857_a("owner");
        }
        if (tagCompound.func_74764_b("ownername")) {
            this.username = tagCompound.func_74779_i("ownername");
        }
        if (tagCompound.func_74764_b("bypass_recipecheck")) {
            ItemStack liquid = this.func_70301_a(1);
            ItemStack ingredient = this.func_70301_a(2);
            if (!liquid.func_190926_b()) {
                this.checkedRecipe = AlchemicalCauldronCraftingManager.getInstance().findRecipe(liquid, ingredient);
            }
        }
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.totalBurnTime = value;
                break;
            }
            case 1: {
                this.burnTime = value;
                break;
            }
            case 2: {
                this.totalCookTime = value;
                break;
            }
            case 3: {
                this.cookTime = value;
            }
        }
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (slot == 1 && this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
        }
    }

    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        boolean wasCooking = this.cookTime > 0;
        boolean dirty = false;
        if (wasBurning) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning() || this.isStackInSlot(1) && this.isStackInSlot(3)) {
                if (!this.isBurning() && this.canCook()) {
                    this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(3));
                    if (this.isBurning()) {
                        this.func_70298_a(3, 1);
                        dirty = true;
                    }
                    this.totalBurnTime = this.burnTime;
                }
                if (this.isBurning() && this.canCook()) {
                    ++this.cookTime;
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.finishCooking();
                        dirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (wasBurning != this.isBurning()) {
                dirty = true;
            } else if (wasCooking != this.cookTime > 0) {
                dirty = true;
            }
        } else if (this.isCooking() && this.boilingSound == null && this.field_145850_b.field_73012_v.nextInt(25) == 0) {
            this.boilingSound = VampLib.proxy.createSoundReference(ModSounds.boiling, SoundCategory.BLOCKS, this.func_174877_v(), 0.015f, 7.0f);
            this.boilingSound.startPlaying();
        } else if (!this.isCooking() && this.boilingSound != null) {
            this.boilingSound.stopPlaying();
            this.boilingSound = null;
        }
        if (dirty) {
            this.markDirty(true);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("burntime", this.burnTime);
        compound.func_74768_a("cooktime", this.cookTime);
        compound.func_74768_a("cooktime_total", this.totalCookTime);
        if (this.ownerID != null) {
            compound.func_186854_a("owner", this.ownerID);
        }
        if (this.username != null) {
            compound.func_74778_a("ownername", this.username);
        }
        if (this.checkedRecipe != null) {
            compound.func_74757_a("bypass_recipecheck", true);
        }
        return compound;
    }

    private boolean canCook() {
        if (!this.isStackInSlot(1)) {
            return false;
        }
        IAlchemicalCauldronRecipe recipe = AlchemicalCauldronCraftingManager.getInstance().findRecipe(this.func_70301_a(1), this.func_70301_a(2));
        if (recipe == null) {
            return false;
        }
        this.totalCookTime = recipe.getCookingTime();
        if (!this.canPlayerCook(recipe)) {
            return false;
        }
        if (!this.isStackInSlot(0)) {
            return true;
        }
        if (!this.func_70301_a(0).func_77969_a(recipe.getOutput())) {
            return false;
        }
        int size = this.func_70301_a(0).func_190916_E() + recipe.getOutput().func_190916_E();
        return size <= this.func_70297_j_() && size <= this.func_70301_a(0).func_77976_d();
    }

    private boolean canPlayerCook(IAlchemicalCauldronRecipe recipe) {
        if (this.checkedRecipe != null && this.checkedRecipe.equals(recipe)) {
            return true;
        }
        EntityPlayer owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        HunterPlayer player = HunterPlayer.get(owner);
        ISkillHandler<IHunterPlayer> handler = player.getSkillHandler();
        boolean flag = recipe.canBeCooked(player.getLevel(), handler);
        if (flag) {
            this.checkedRecipe = recipe;
            return true;
        }
        this.checkedRecipe = null;
        return false;
    }

    private void finishCooking() {
        if (this.canCook()) {
            IAlchemicalCauldronRecipe recipe = AlchemicalCauldronCraftingManager.getInstance().findRecipe(this.func_70301_a(1), this.func_70301_a(2));
            if (!this.isStackInSlot(0)) {
                this.func_70299_a(0, recipe.getOutput().func_77946_l());
            } else if (this.func_70301_a(0).func_77969_a(recipe.getOutput())) {
                this.func_70301_a(0).func_190917_f(recipe.getOutput().func_190916_E());
            }
            if (recipe.isValidLiquidItem(this.func_70301_a(1))) {
                this.func_70298_a(1, 1);
            } else {
                ItemStack fluidContainer = this.func_70301_a(1);
                FluidStack s = recipe.isValidFluidItem(fluidContainer);
                if (s != null) {
                    IFluidHandlerItem handler = (IFluidHandlerItem)FluidLib.getFluidItemCap(fluidContainer);
                    handler.drain(s, true);
                    this.func_70299_a(1, handler.getContainer());
                } else {
                    VampirismMod.log.w("AlchemicalCauldron", "Cooked item without valid input liquid (Recipe %s, Input %s)", recipe, fluidContainer);
                }
            }
            this.func_70298_a(2, 1);
        }
    }

    private int getCookTime() {
        return 200;
    }

    @Nullable
    private EntityPlayer getOwner() {
        if (this.ownerID != null && !this.field_145850_b.field_72995_K) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.ownerID);
        }
        return null;
    }

    public void setOwner(EntityPlayer player) {
        this.ownerID = player.getPersistentID();
        this.markDirty(true);
    }

    private boolean isStackInSlot(int slot) {
        return !this.func_70301_a(slot).func_190926_b();
    }
}

