/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TilePedestal
extends TileEntity
implements ITickable,
IItemHandler {
    private final Random rand = new Random();
    private int ticksExistedClient;
    private int chargingTicks;
    private int bloodStored = 0;
    private int chargeRate = 30;
    @Nonnull
    private ItemStack internalStack = ItemStack.field_190927_a;

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.internalStack;
        if (slot == 0 && !stack.func_190926_b()) {
            if (!simulate) {
                this.removeStack();
                this.markDirtyAndUpdateClient();
            }
            return simulate ? stack.func_77946_l() : stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackForRender() {
        return this.internalStack;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.internalStack : ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTickForRender() {
        return this.ticksExistedClient;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.DOWN) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public boolean hasStack() {
        return !this.internalStack.func_190926_b();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 0 && this.internalStack.func_190926_b()) {
            if (!simulate) {
                this.setStack(stack);
                this.markDirtyAndUpdateClient();
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    private void markDirtyAndUpdateClient() {
        super.func_70296_d();
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, block, block, 3);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.internalStack = compound.func_74764_b("item") ? new ItemStack(compound.func_74775_l("item")) : ItemStack.field_190927_a;
        this.bloodStored = compound.func_74762_e("blood_stored");
        this.chargingTicks = compound.func_74762_e("charging_ticks");
    }

    @Nonnull
    public ItemStack removeStack() {
        ItemStack stack = this.internalStack;
        this.internalStack = ItemStack.field_190927_a;
        return stack;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.chargingTicks > 0) {
                --this.chargingTicks;
                if (this.chargingTicks == 0) {
                    IBloodChargeable chargeable = this.getChargeItem(this.internalStack);
                    if (chargeable != null && this.bloodStored > 0) {
                        int charged = chargeable.charge(this.internalStack, this.bloodStored);
                        this.bloodStored -= Math.max(0, charged);
                    }
                    this.markDirtyAndUpdateClient();
                }
            } else if (this.chargingTicks == 0) {
                IBloodChargeable chargeable = this.getChargeItem(this.internalStack);
                if (chargeable != null && chargeable.canBeCharged(this.internalStack)) {
                    if (this.bloodStored < this.chargeRate) {
                        this.drainBlood();
                    }
                    if (this.bloodStored > 0) {
                        this.chargingTicks = 20;
                        this.markDirtyAndUpdateClient();
                    } else {
                        this.chargingTicks = -40;
                    }
                } else {
                    this.chargingTicks = -40;
                }
            } else {
                ++this.chargingTicks;
            }
        } else {
            ++this.ticksExistedClient;
            if (this.chargingTicks > 0 && this.ticksExistedClient % 8 == 0) {
                this.spawnChargedParticle();
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.hasStack()) {
            compound.func_74782_a("item", (NBTBase)this.internalStack.serializeNBT());
        }
        compound.func_74768_a("blood_stored", this.bloodStored);
        compound.func_74768_a("charging_ticks", this.chargingTicks);
        return super.func_189515_b(compound);
    }

    private void drainBlood() {
        FluidStack drained;
        IFluidHandler handler = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (EnumFacing)EnumFacing.UP);
        if (handler != null && (drained = handler.drain(new FluidStack(ModFluids.blood, 100), false)) != null && drained.amount == 100 && (drained = handler.drain(new FluidStack(ModFluids.blood, 100), true)) != null) {
            this.bloodStored += drained.amount;
        }
    }

    @Nullable
    private IBloodChargeable getChargeItem(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? null : (stack.func_77973_b() instanceof IBloodChargeable ? (IBloodChargeable)stack.func_77973_b() : null);
    }

    private boolean setStack(@Nonnull ItemStack stack) {
        this.chargingTicks = 0;
        if (this.internalStack.func_190926_b()) {
            this.internalStack = stack;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnChargedParticle() {
        Vec3d pos = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.8, 0.5);
        VampLib.proxy.getParticleHandler().spawnParticle(this.func_145831_w(), ModParticles.FLYING_BLOOD, (double)this.field_174879_c.func_177958_n() + 0.2, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.2, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f)), 177);
        VampLib.proxy.getParticleHandler().spawnParticle(this.func_145831_w(), ModParticles.FLYING_BLOOD, (double)this.field_174879_c.func_177958_n() + 0.8, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.2, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f)), 177);
        VampLib.proxy.getParticleHandler().spawnParticle(this.func_145831_w(), ModParticles.FLYING_BLOOD, (double)this.field_174879_c.func_177958_n() + 0.2, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.8, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f)), 177);
        VampLib.proxy.getParticleHandler().spawnParticle(this.func_145831_w(), ModParticles.FLYING_BLOOD, (double)this.field_174879_c.func_177958_n() + 0.8, (double)this.func_174877_v().func_177956_o() + 0.65, (double)this.func_174877_v().func_177952_p() + 0.8, pos.field_72450_a + (double)(1.0f - this.rand.nextFloat()) * 0.1, pos.field_72448_b + (double)(1.0f - this.rand.nextFloat()) * 0.2, pos.field_72449_c + (double)(1.0f - this.rand.nextFloat()) * 0.1, (int)(3.0f / (this.rand.nextFloat() * 0.6f + 0.4f)), 177);
    }
}

