/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.world.gen.structure.VampirismTemplate;
import de.teamlapen.vampirism.world.loot.LootHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class StructureManager {
    private static final Map<Structure, VampirismTemplate> templates = Maps.newHashMap();
    private static final String TAG = "StructureManager";

    public static void init() {
        VampirismMod.log.d(TAG, "Loading structures", new Object[0]);
        for (Structure s : Structure.values()) {
            StructureManager.loadTemplate(s);
        }
        VampirismMod.log.d(TAG, "Loaded %s structures", Structure.values().length);
    }

    private static void loadTemplate(Structure structure) {
        InputStream input = StructureManager.class.getResourceAsStream("/structures/" + structure.name + ".nbt");
        if (input == null) {
            VampirismMod.log.e(TAG, "Failed to locate structure file %s", structure.name);
            return;
        }
        try {
            NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)input);
            VampirismTemplate template = new VampirismTemplate();
            template.func_186256_b(data);
            templates.put(structure, template);
            if (structure.loot) {
                template.setLootTable(LootHandler.addStructureLootTable(structure.name));
            }
        }
        catch (IOException e) {
            VampirismMod.log.e(TAG, e, "Failed to load structure file %s", structure.name);
        }
    }

    @Nullable
    public static VampirismTemplate get(@Nonnull Structure s) {
        return templates.get((Object)s);
    }

    public static enum Structure {
        HOUSE1("house1", true);

        String name;
        boolean loot;

        private Structure(String name, boolean loot) {
            this.name = name;
            this.loot = loot;
        }
    }
}

