/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.localization.GuiText;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class GuiImgLabel
extends GuiLabel
implements ITooltip {
    private final Enum labelSetting;
    private Enum currentValue;
    private static Map<GuiImgButton.EnumPair, LabelAppearance> appearances;
    private final FontRenderer fontRenderer;

    public GuiImgLabel(FontRenderer fontRendererObj, int x, int y, Enum idx, Enum val) {
        super(fontRendererObj, 0, x, y, 16, 16, 0);
        this.currentValue = val;
        this.labelSetting = idx;
        this.fontRenderer = fontRendererObj;
        if (appearances == null) {
            appearances = new HashMap<GuiImgButton.EnumPair, LabelAppearance>();
            this.registerApp(10, Settings.UNLOCK, LockCraftingMode.NONE, GuiText.NoneLock, null, 65280);
            this.registerApp(9, Settings.UNLOCK, LockCraftingMode.LOCK_WHILE_LOW, GuiText.CraftingLock, (Object)GuiText.LowRedstoneLock, 0xFF0000);
            this.registerApp(9, Settings.UNLOCK, LockCraftingMode.LOCK_WHILE_HIGH, GuiText.CraftingLock, (Object)GuiText.HighRedstoneLock, 0xFF0000);
            this.registerApp(9, Settings.UNLOCK, LockCraftingMode.LOCK_UNTIL_PULSE, GuiText.CraftingLock, (Object)GuiText.UntilPulseUnlock, 0xFF0000);
            this.registerApp(9, Settings.UNLOCK, LockCraftingMode.LOCK_UNTIL_RESULT, GuiText.CraftingLock, (Object)GuiText.ResultLock, 0xFF0000);
        }
    }

    public void setVisibility(boolean vis) {
        this.field_146172_j = vis;
    }

    public void func_146159_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146172_j) {
            int iconIndex = this.getIconIndex();
            if (iconIndex == -1) {
                return;
            }
            mc.field_71446_o.func_110577_a(new ResourceLocation("appliedenergistics2", "textures/guis/states.png"));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int uv_y = (int)Math.floor(iconIndex / 16);
            int uv_x = iconIndex - uv_y * 16;
            this.func_73729_b(this.field_146162_g, this.field_146174_h, uv_x * 16, uv_y * 16, 16, 16);
            if (this.labelSetting != null && this.currentValue != null) {
                LabelAppearance labelAppearance = appearances.get(new GuiImgButton.EnumPair(this.labelSetting, this.currentValue));
                String translated = I18n.func_74838_a((String)labelAppearance.displayLabel);
                this.fontRenderer.func_78276_b(translated, this.field_146162_g + 16, this.field_146174_h + 5, labelAppearance.color);
                this.field_146167_a = 16 + this.fontRenderer.func_78256_a(translated);
            }
        }
    }

    private int getIconIndex() {
        if (this.labelSetting != null && this.currentValue != null) {
            LabelAppearance app = appearances.get(new GuiImgButton.EnumPair(this.labelSetting, this.currentValue));
            if (app == null) {
                return -1;
            }
            return app.index;
        }
        return -1;
    }

    private void registerApp(int iconIndex, Settings setting, Enum val, GuiText label, Object hint, int color) {
        LabelAppearance a = new LabelAppearance();
        a.hiddenValue = hint != null ? (String)(hint instanceof String ? hint : ((GuiText)((Object)hint)).getUnlocalized()) : null;
        a.index = iconIndex;
        a.displayLabel = label.getUnlocalized();
        a.color = color;
        appearances.put(new GuiImgButton.EnumPair(setting, val), a);
    }

    @Override
    public String getMessage() {
        if (this.labelSetting != null && this.currentValue != null) {
            LabelAppearance labelAppearance = appearances.get(new GuiImgButton.EnumPair(this.labelSetting, this.currentValue));
            if (labelAppearance == null) {
                return "No Such Message";
            }
            if (labelAppearance.hiddenValue != null) {
                return I18n.func_74838_a((String)labelAppearance.hiddenValue);
            }
        }
        return null;
    }

    public void set(Enum e) {
        if (this.currentValue != e) {
            this.currentValue = e;
        }
    }

    @Override
    public int xPos() {
        return this.field_146162_g;
    }

    @Override
    public int yPos() {
        return this.field_146174_h;
    }

    @Override
    public int getWidth() {
        return this.field_146167_a;
    }

    @Override
    public int getHeight() {
        return this.field_146161_f;
    }

    @Override
    public boolean isVisible() {
        return this.field_146172_j;
    }

    private static class LabelAppearance {
        public int index;
        public String displayLabel;
        public String hiddenValue;
        public int color;

        private LabelAppearance() {
        }
    }
}

