/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.features.IRegistryContainer;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWorldGen;
import appeng.api.movable.IMovableRegistry;
import appeng.api.networking.IGridCacheRegistry;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.bootstrap.ICriterionTriggerRegistry;
import appeng.bootstrap.IModelRegistry;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IEntityRegistrationComponent;
import appeng.bootstrap.components.IInitComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IModelRegistrationComponent;
import appeng.bootstrap.components.IOreDictComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.bootstrap.components.IPreInitComponent;
import appeng.bootstrap.components.IRecipeRegistrationComponent;
import appeng.capabilities.Capabilities;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiItems;
import appeng.core.api.definitions.ApiParts;
import appeng.core.features.AEFeature;
import appeng.core.features.registries.P2PTunnelRegistry;
import appeng.core.features.registries.cell.BasicCellHandler;
import appeng.core.features.registries.cell.BasicItemCellGuiHandler;
import appeng.core.features.registries.cell.CreativeCellHandler;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.stats.AdvancementTriggers;
import appeng.core.stats.PartItemPredicate;
import appeng.core.stats.Stats;
import appeng.core.worlddata.SpatialDimensionManager;
import appeng.fluids.registries.BasicFluidCellGuiHandler;
import appeng.hooks.TickHandler;
import appeng.hooks.WrenchClickHook;
import appeng.items.materials.ItemMaterial;
import appeng.items.parts.ItemFacade;
import appeng.items.parts.ItemPart;
import appeng.loot.ChestLoot;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cache.EnergyGridCache;
import appeng.me.cache.GridStorageCache;
import appeng.me.cache.P2PCache;
import appeng.me.cache.PathGridCache;
import appeng.me.cache.SecurityCache;
import appeng.me.cache.SpatialPylonCache;
import appeng.me.cache.TickManagerCache;
import appeng.recipes.AEItemResolver;
import appeng.recipes.AERecipeLoader;
import appeng.recipes.game.DisassembleRecipe;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.ores.OreDictionaryHandler;
import appeng.spatial.BiomeGenStorage;
import appeng.spatial.StorageWorldProvider;
import appeng.tile.AEBaseTile;
import appeng.worldgen.MeteoriteWorldGen;
import appeng.worldgen.QuartzWorldGen;
import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

final class Registration {
    DimensionType storageDimensionType;
    int storageDimensionID;
    Biome storageBiome;
    AdvancementTriggers advancementTriggers;

    Registration() {
    }

    void preInitialize(FMLPreInitializationEvent event) {
        Capabilities.register();
        Api api = Api.INSTANCE;
        IRecipeHandlerRegistry recipeRegistry = api.registries().recipes();
        this.registerCraftHandlers(recipeRegistry);
        MinecraftForge.EVENT_BUS.register((Object)OreDictionaryHandler.INSTANCE);
        ApiDefinitions definitions = api.definitions();
        definitions.getRegistry().getBootstrapComponents(IPreInitComponent.class).forEachRemaining(b -> b.preInitialize(event.getSide()));
    }

    private void registerSpatialBiome(IForgeRegistry<Biome> registry) {
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.SPATIAL_IO)) {
            return;
        }
        if (this.storageBiome == null) {
            this.storageBiome = new BiomeGenStorage();
        }
        registry.register((IForgeRegistryEntry)((Biome)this.storageBiome.setRegistryName("appliedenergistics2:storage_biome")));
    }

    private void registerSpatialDimension() {
        AEConfig config = AEConfig.instance();
        if (!config.isFeatureEnabled(AEFeature.SPATIAL_IO)) {
            return;
        }
        if (config.getStorageProviderID() == -1) {
            HashSet<Integer> ids = new HashSet<Integer>();
            for (DimensionType type : DimensionType.values()) {
                ids.add(type.func_186068_a());
            }
            int newId = -11;
            while (ids.contains(newId)) {
                --newId;
            }
            config.setStorageProviderID(newId);
            config.save();
        }
        this.storageDimensionType = DimensionType.register((String)"Storage Cell", (String)"_cell", (int)config.getStorageProviderID(), StorageWorldProvider.class, (boolean)true);
        if (config.getStorageDimensionID() == -1) {
            config.setStorageDimensionID(DimensionManager.getNextFreeDimId());
            config.save();
        }
        this.storageDimensionID = config.getStorageDimensionID();
        DimensionManager.registerDimension((int)this.storageDimensionID, (DimensionType)this.storageDimensionType);
    }

    private void registerCraftHandlers(IRecipeHandlerRegistry registry) {
        registry.addNewSubItemResolver(new AEItemResolver());
    }

    public void initialize(@Nonnull FMLInitializationEvent event, @Nonnull File recipeDirectory) {
        Preconditions.checkNotNull((Object)event);
        Preconditions.checkNotNull((Object)recipeDirectory);
        Preconditions.checkArgument((!recipeDirectory.isFile() ? 1 : 0) != 0);
        Api api = Api.INSTANCE;
        IRegistryContainer registries = api.registries();
        ApiDefinitions definitions = api.definitions();
        definitions.getRegistry().getBootstrapComponents(IInitComponent.class).forEachRemaining(b -> b.initialize(event.getSide()));
        MinecraftForge.EVENT_BUS.register((Object)TickHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new WrenchClickHook());
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CHEST_LOOT)) {
            MinecraftForge.EVENT_BUS.register((Object)new ChestLoot());
        }
        IGridCacheRegistry gcr = registries.gridCache();
        gcr.registerGridCache(ITickManager.class, TickManagerCache.class);
        gcr.registerGridCache(IEnergyGrid.class, EnergyGridCache.class);
        gcr.registerGridCache(IPathingGrid.class, PathGridCache.class);
        gcr.registerGridCache(IStorageGrid.class, GridStorageCache.class);
        gcr.registerGridCache(P2PCache.class, P2PCache.class);
        gcr.registerGridCache(ISpatialCache.class, SpatialPylonCache.class);
        gcr.registerGridCache(ISecurityGrid.class, SecurityCache.class);
        gcr.registerGridCache(ICraftingGrid.class, CraftingGridCache.class);
        registries.cell().addCellHandler(new BasicCellHandler());
        registries.cell().addCellHandler(new CreativeCellHandler());
        registries.cell().addCellGuiHandler(new BasicItemCellGuiHandler());
        registries.cell().addCellGuiHandler(new BasicFluidCellGuiHandler());
        api.definitions().materials().matterBall().maybeStack(1).ifPresent(ammoStack -> {
            double weight = 32.0;
            registries.matterCannon().registerAmmo((ItemStack)ammoStack, 32.0);
        });
        PartItemPredicate.register();
        Stats.register();
        this.advancementTriggers = new AdvancementTriggers(new CriterionTrigggerRegistry());
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        this.registerSpatialBiome((IForgeRegistry<Biome>)registry);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void modelRegistryEvent(ModelRegistryEvent event) {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        ModelLoaderWrapper registry = new ModelLoaderWrapper();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        definitions.getRegistry().getBootstrapComponents(IModelRegistrationComponent.class).forEachRemaining(b -> b.modelRegistration(side, registry));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        definitions.getRegistry().getBootstrapComponents(IBlockRegistrationComponent.class).forEachRemaining(b -> b.blockRegistration(side, (IForgeRegistry<Block>)registry));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        definitions.getRegistry().getBootstrapComponents(IItemRegistrationComponent.class).forEachRemaining(b -> b.itemRegistration(side, (IForgeRegistry<Item>)registry));
        definitions.getRegistry().getBootstrapComponents(IOreDictComponent.class).forEachRemaining(b -> b.oreRegistration(side));
        ItemMaterial.instance.registerOredicts();
        ItemPart.instance.registerOreDicts();
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        Api api = Api.INSTANCE;
        ApiDefinitions definitions = api.definitions();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING)) {
            DisassembleRecipe r = new DisassembleRecipe();
            registry.register((IForgeRegistryEntry)((IRecipe)r.setRegistryName("appliedenergistics2".toLowerCase(), "disassemble")));
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_FACADE_CRAFTING)) {
            definitions.items().facade().maybeItem().ifPresent(facadeItem -> {
                FacadeRecipe f = new FacadeRecipe((ItemFacade)facadeItem);
                registry.register((IForgeRegistryEntry)((IRecipe)f.setRegistryName("appliedenergistics2".toLowerCase(), "facade")));
            });
        }
        definitions.getRegistry().getBootstrapComponents(IRecipeRegistrationComponent.class).forEachRemaining(b -> b.recipeRegistration(side, (IForgeRegistry<IRecipe>)registry));
        AERecipeLoader ldr = new AERecipeLoader();
        ldr.loadProcessingRecipes();
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IEntityRegistrationComponent.class).forEachRemaining(b -> b.entityRegistration((IForgeRegistry<EntityEntry>)registry));
    }

    @SubscribeEvent
    public void attachSpatialDimensionManager(AttachCapabilitiesEvent<World> event) {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.SPATIAL_IO) && event.getObject() == DimensionManager.getWorld((int)AEConfig.instance().getStorageDimensionID())) {
            event.addCapability(new ResourceLocation("appliedenergistics2:spatial_dimension_manager"), (ICapabilityProvider)new SpatialDimensionManager((World)event.getObject()));
        }
    }

    void postInit(FMLPostInitializationEvent event) {
        IRegistryContainer registries = Api.INSTANCE.registries();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        ApiParts parts = definitions.parts();
        ApiBlocks blocks = definitions.blocks();
        ApiItems items = definitions.items();
        this.registerSpatialDimension();
        ((P2PTunnelRegistry)registries.p2pTunnel()).configure();
        PlayerMessages.values();
        GuiText.values();
        definitions.getRegistry().getBootstrapComponents(IPostInitComponent.class).forEachRemaining(b -> b.postInitialize(event.getSide()));
        Upgrades.CRAFTING.registerItem(parts.iface(), 1);
        Upgrades.CRAFTING.registerItem(blocks.iface(), 1);
        Upgrades.PATTERN_EXPANSION.registerItem(parts.iface(), 3);
        Upgrades.PATTERN_EXPANSION.registerItem(blocks.iface(), 3);
        Upgrades.CAPACITY.registerItem(parts.fluidIface(), 2);
        Upgrades.CAPACITY.registerItem(blocks.fluidIface(), 2);
        Upgrades.SPEED.registerItem(blocks.iOPort(), 3);
        Upgrades.REDSTONE.registerItem(blocks.iOPort(), 1);
        Upgrades.FUZZY.registerItem(parts.levelEmitter(), 1);
        Upgrades.CRAFTING.registerItem(parts.levelEmitter(), 1);
        Upgrades.FUZZY.registerItem(parts.importBus(), 1);
        Upgrades.REDSTONE.registerItem(parts.importBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.importBus(), 2);
        Upgrades.SPEED.registerItem(parts.importBus(), 4);
        Upgrades.CAPACITY.registerItem(parts.fluidImportBus(), 2);
        Upgrades.REDSTONE.registerItem(parts.fluidImportBus(), 1);
        Upgrades.SPEED.registerItem(parts.fluidImportBus(), 4);
        Upgrades.FUZZY.registerItem(parts.exportBus(), 1);
        Upgrades.REDSTONE.registerItem(parts.exportBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.exportBus(), 2);
        Upgrades.SPEED.registerItem(parts.exportBus(), 4);
        Upgrades.CRAFTING.registerItem(parts.exportBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.fluidExportBus(), 2);
        Upgrades.REDSTONE.registerItem(parts.fluidExportBus(), 1);
        Upgrades.SPEED.registerItem(parts.fluidExportBus(), 4);
        Upgrades.FUZZY.registerItem(items.cell1k(), 1);
        Upgrades.INVERTER.registerItem(items.cell1k(), 1);
        Upgrades.STICKY.registerItem(items.cell1k(), 1);
        Upgrades.FUZZY.registerItem(items.cell4k(), 1);
        Upgrades.INVERTER.registerItem(items.cell4k(), 1);
        Upgrades.STICKY.registerItem(items.cell4k(), 1);
        Upgrades.FUZZY.registerItem(items.cell16k(), 1);
        Upgrades.INVERTER.registerItem(items.cell16k(), 1);
        Upgrades.STICKY.registerItem(items.cell16k(), 1);
        Upgrades.FUZZY.registerItem(items.cell64k(), 1);
        Upgrades.INVERTER.registerItem(items.cell64k(), 1);
        Upgrades.STICKY.registerItem(items.cell64k(), 1);
        Upgrades.FUZZY.registerItem(items.portableCell(), 1);
        Upgrades.INVERTER.registerItem(items.portableCell(), 1);
        Upgrades.FUZZY.registerItem(items.viewCell(), 1);
        Upgrades.INVERTER.registerItem(items.viewCell(), 1);
        Upgrades.FUZZY.registerItem(AEApi.instance().definitions().materials().cardMagnet(), 1);
        Upgrades.INVERTER.registerItem(AEApi.instance().definitions().materials().cardMagnet(), 1);
        Upgrades.INVERTER.registerItem(items.fluidCell1k(), 1);
        Upgrades.STICKY.registerItem(items.fluidCell1k(), 1);
        Upgrades.INVERTER.registerItem(items.fluidCell4k(), 1);
        Upgrades.STICKY.registerItem(items.fluidCell4k(), 1);
        Upgrades.INVERTER.registerItem(items.fluidCell16k(), 1);
        Upgrades.STICKY.registerItem(items.fluidCell16k(), 1);
        Upgrades.INVERTER.registerItem(items.fluidCell64k(), 1);
        Upgrades.STICKY.registerItem(items.fluidCell64k(), 1);
        Upgrades.FUZZY.registerItem(parts.storageBus(), 1);
        Upgrades.INVERTER.registerItem(parts.storageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.storageBus(), 5);
        Upgrades.STICKY.registerItem(parts.storageBus(), 1);
        Upgrades.STICKY.registerItem(parts.oreDictStorageBus(), 1);
        Upgrades.INVERTER.registerItem(parts.fluidStorageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.fluidStorageBus(), 5);
        Upgrades.STICKY.registerItem(parts.fluidStorageBus(), 1);
        Upgrades.FUZZY.registerItem(parts.formationPlane(), 1);
        Upgrades.INVERTER.registerItem(parts.formationPlane(), 1);
        Upgrades.CAPACITY.registerItem(parts.formationPlane(), 5);
        Upgrades.FUZZY.registerItem(items.massCannon(), 1);
        Upgrades.INVERTER.registerItem(items.massCannon(), 1);
        Upgrades.SPEED.registerItem(items.massCannon(), 4);
        Upgrades.SPEED.registerItem(blocks.molecularAssembler(), 5);
        Upgrades.SPEED.registerItem(blocks.inscriber(), 3);
        Upgrades.QUANTUM_LINK.registerItem(blocks.quantumLink(), 1);
        ArrayList<IItemDefinition> iids = new ArrayList<IItemDefinition>();
        iids.add(items.wirelessTerminal());
        iids.add(items.wirelessCraftingTerminal());
        iids.add(items.wirelessPatternTerminal());
        for (IItemDefinition iItemDefinition : iids) {
            iItemDefinition.maybeItem().ifPresent(terminal -> {
                registries.wireless().registerWirelessHandler((IWirelessTermHandler)terminal);
                Upgrades.MAGNET.registerItem(id, 1);
            });
        }
        items.wirelessFluidTerminal().maybeItem().ifPresent(terminal -> registries.wireless().registerWirelessHandler((IWirelessTermHandler)terminal));
        items.wirelessInterfaceTerminal().maybeItem().ifPresent(terminal -> registries.wireless().registerWirelessHandler((IWirelessTermHandler)terminal));
        items.chargedStaff().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 320.0));
        items.portableCell().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 800.0));
        items.colorApplicator().maybeItem().ifPresent(colorApplicator -> registries.charger().addChargeRate((Item)colorApplicator, 800.0));
        items.wirelessTerminal().maybeItem().ifPresent(terminal -> registries.charger().addChargeRate((Item)terminal, 8000.0));
        items.entropyManipulator().maybeItem().ifPresent(entropyManipulator -> registries.charger().addChargeRate((Item)entropyManipulator, 8000.0));
        items.massCannon().maybeItem().ifPresent(massCannon -> registries.charger().addChargeRate((Item)massCannon, 8000.0));
        blocks.energyCell().maybeItem().ifPresent(cell -> registries.charger().addChargeRate((Item)cell, 8000.0));
        blocks.energyCellDense().maybeItem().ifPresent(cell -> registries.charger().addChargeRate((Item)cell, 16000.0));
        if (AEConfig.instance().isFeatureEnabled(AEFeature.VILLAGER_TRADING)) {
            // empty if block
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new QuartzWorldGen(), (int)0);
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new MeteoriteWorldGen(), (int)0);
        }
        IMovableRegistry mr = registries.movable();
        mr.blacklistBlock(Blocks.field_150357_h);
        mr.whiteListTileEntity(TileEntityBanner.class);
        mr.whiteListTileEntity(TileEntityBeacon.class);
        mr.whiteListTileEntity(TileEntityBrewingStand.class);
        mr.whiteListTileEntity(TileEntityChest.class);
        mr.whiteListTileEntity(TileEntityCommandBlock.class);
        mr.whiteListTileEntity(TileEntityComparator.class);
        mr.whiteListTileEntity(TileEntityDaylightDetector.class);
        mr.whiteListTileEntity(TileEntityDispenser.class);
        mr.whiteListTileEntity(TileEntityDropper.class);
        mr.whiteListTileEntity(TileEntityEnchantmentTable.class);
        mr.whiteListTileEntity(TileEntityEnderChest.class);
        mr.whiteListTileEntity(TileEntityEndPortal.class);
        mr.whiteListTileEntity(TileEntityFlowerPot.class);
        mr.whiteListTileEntity(TileEntityFurnace.class);
        mr.whiteListTileEntity(TileEntityHopper.class);
        mr.whiteListTileEntity(TileEntityMobSpawner.class);
        mr.whiteListTileEntity(TileEntityNote.class);
        mr.whiteListTileEntity(TileEntityPiston.class);
        mr.whiteListTileEntity(TileEntityShulkerBox.class);
        mr.whiteListTileEntity(TileEntitySign.class);
        mr.whiteListTileEntity(TileEntitySkull.class);
        mr.whiteListTileEntity(AEBaseTile.class);
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            registries.worldgen().disableWorldGenForProviderID(type, StorageWorldProvider.class);
            registries.worldgen().disableWorldGenForDimension(type, -1);
            registries.worldgen().disableWorldGenForDimension(type, 1);
        }
        for (int dimension : AEConfig.instance().getMeteoriteDimensionWhitelist()) {
            registries.worldgen().enableWorldGenForDimension(IWorldGen.WorldGenType.METEORITES, dimension);
        }
    }

    private static class CriterionTrigggerRegistry
    implements ICriterionTriggerRegistry {
        private final Method method = ReflectionHelper.findMethod(CriteriaTriggers.class, (String)"register", (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});

        CriterionTrigggerRegistry() {
            this.method.setAccessible(true);
        }

        @Override
        public void register(ICriterionTrigger<? extends ICriterionInstance> trigger) {
            try {
                this.method.invoke(null, trigger);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                AELog.debug(e);
            }
        }
    }

    private static class ModelLoaderWrapper
    implements IModelRegistry {
        private ModelLoaderWrapper() {
        }

        @Override
        public void registerItemVariants(Item item, ResourceLocation ... names) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])names);
        }

        @Override
        public void setCustomModelResourceLocation(Item item, int metadata, ModelResourceLocation model) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)model);
        }

        @Override
        public void setCustomMeshDefinition(Item item, ItemMeshDefinition meshDefinition) {
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
        }

        @Override
        public void setCustomStateMapper(Block block, IStateMapper mapper) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }
}

