/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.localization;

import appeng.api.config.PowerUnits;
import appeng.core.localization.GuiText;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public final class Tooltips {
    private static final char SEP;
    public static final Style UNIT_TEXT;
    public static final Style NORMAL_TOOLTIP_TEXT;
    public static final Style NUMBER_TEXT;
    public static final String[] units;
    public static final long[] DECIMAL_NUMS;

    public static ITextComponent of(ITextComponent ... components) {
        TextComponentString s = new TextComponentString("");
        for (ITextComponent c : components) {
            s = s.func_150257_a(c);
        }
        return s;
    }

    public static ITextComponent of(String s) {
        return new TextComponentString(s);
    }

    public static ITextComponent ofPercent(double percent) {
        return Tooltips.ofPercent(percent, true);
    }

    public static ITextComponent ofPercent(double percent, boolean oneIsGreen) {
        return new TextComponentString(MessageFormat.format("{0,number,#.##%}", percent)).func_150255_a(Tooltips.colorFromRatio(percent, oneIsGreen));
    }

    public static ITextComponent of(PowerUnits pU) {
        return new TextComponentTranslation(pU.unlocalizedName, new Object[0]).func_150255_a(UNIT_TEXT);
    }

    public static ITextComponent ofNumber(double number, double max) {
        MaxedAmount amount = Tooltips.getMaxedAmount(number, max);
        return Tooltips.ofNumber(amount);
    }

    public static ITextComponent of(GuiText guiText, Object ... args) {
        return Tooltips.of(guiText, NORMAL_TOOLTIP_TEXT, args);
    }

    public static ITextComponent of(GuiText guiText, Style style, Object ... args) {
        if (args.length > 0 && args[0] instanceof Integer) {
            return guiText.getLocalizedWithArgs(Arrays.stream(args).map(o -> Tooltips.ofUnformattedNumber(((Integer)o).intValue())).toArray()).func_150259_f().func_150255_a(style);
        }
        if (args.length > 0 && args[0] instanceof Long) {
            return guiText.getLocalizedWithArgs(Arrays.stream(args).map(o -> Tooltips.ofUnformattedNumber((Long)o)).toArray()).func_150259_f().func_150255_a(style);
        }
        return guiText.getLocalizedWithArgs(args).func_150259_f().func_150255_a(style);
    }

    public static ITextComponent ofUnformattedNumber(long number) {
        return new TextComponentString(String.valueOf(number)).func_150255_a(NUMBER_TEXT);
    }

    public static ITextComponent ofUnformattedNumberWithRatioColor(long number, double ratio, boolean oneIsGreen) {
        return new TextComponentString(String.valueOf(number)).func_150255_a(Tooltips.colorFromRatio(ratio, oneIsGreen));
    }

    private static ITextComponent ofNumber(MaxedAmount number) {
        boolean numberUnit = !number.digit().equals("0");
        return new TextComponentString(number.digit() + (numberUnit ? number.unit() : "")).func_150255_a(NUMBER_TEXT).func_150257_a(new TextComponentString("/").func_150255_a(NORMAL_TOOLTIP_TEXT)).func_150258_a(number.maxDigit() + number.unit()).func_150255_a(NUMBER_TEXT);
    }

    public static Style colorFromRatio(double ratio, boolean oneIsGreen) {
        double p = ratio;
        if (!oneIsGreen) {
            p = 1.0 - p;
        }
        TextFormatting colorCode = Tooltips.getColorCode(p);
        return new Style().func_150217_b(Boolean.valueOf(false)).func_150238_a(colorCode);
    }

    public static String getAmount(double amount, long num) {
        double fract = amount / (double)num;
        String returned = fract < 10.0 ? String.format("%.3f", fract) : (fract < 100.0 ? String.format("%.2f", fract) : String.format("%.1f", fract));
        while (returned.endsWith("0")) {
            returned = returned.substring(0, returned.length() - 1);
        }
        if (returned.endsWith(String.valueOf(SEP))) {
            returned = returned.substring(0, returned.length() - 1);
        }
        return returned;
    }

    public static Amount getAmount(double amount) {
        if (amount < 10000.0) {
            return new Amount(Tooltips.getAmount(amount, 1L), "");
        }
        int i = 0;
        while (amount / (double)DECIMAL_NUMS[i] >= 1000.0) {
            ++i;
        }
        return new Amount(Tooltips.getAmount(amount, DECIMAL_NUMS[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(double amount, double max) {
        if (max < 10000.0) {
            return new MaxedAmount(Tooltips.getAmount(amount, 1L), Tooltips.getAmount(max, 1L), "");
        }
        int i = 0;
        while (max / (double)DECIMAL_NUMS[i] >= 1000.0) {
            ++i;
        }
        return new MaxedAmount(Tooltips.getAmount(amount, DECIMAL_NUMS[i]), Tooltips.getAmount(max, DECIMAL_NUMS[i]), units[i]);
    }

    private static TextFormatting getColorCode(double p) {
        if (p < 0.33) {
            return TextFormatting.RED;
        }
        if (p < 0.66) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    public static ITextComponent energyStorageComponent(double energy, double max) {
        return Tooltips.of(Tooltips.of(GuiText.StoredEnergy.getLocal()), Tooltips.of(": "), Tooltips.ofNumber(energy, max), Tooltips.of(" "), Tooltips.of(PowerUnits.AE), Tooltips.of(" ("), Tooltips.ofPercent(energy / max), Tooltips.of(")"));
    }

    public static ITextComponent bytesUsed(long bytes, long max) {
        return Tooltips.of(Tooltips.of(Tooltips.ofUnformattedNumberWithRatioColor(bytes, (double)bytes / (double)max, false), Tooltips.of(" "), Tooltips.of(GuiText.Of, new Object[0]), Tooltips.of(" "), Tooltips.ofUnformattedNumber(max), Tooltips.of(" "), Tooltips.of(GuiText.BytesUsed, new Object[0])));
    }

    public static ITextComponent typesUsed(long types, long max) {
        return Tooltips.of(Tooltips.ofUnformattedNumberWithRatioColor(types, (double)types / (double)max, false), Tooltips.of(" "), Tooltips.of(GuiText.Of, new Object[0]), Tooltips.of(" "), Tooltips.ofUnformattedNumber(max), Tooltips.of(" "), Tooltips.of(GuiText.Types, new Object[0]));
    }

    static {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        SEP = symbols.getDecimalSeparator();
        UNIT_TEXT = new Style().func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(false));
        NORMAL_TOOLTIP_TEXT = new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(false));
        NUMBER_TEXT = new Style().func_150238_a(TextFormatting.LIGHT_PURPLE).func_150217_b(Boolean.valueOf(false));
        units = new String[]{"k", "M", "G", "T", "P", "E"};
        DECIMAL_NUMS = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    }

    public static final class MaxedAmount {
        private final String digit;
        private final String maxDigit;
        private final String unit;

        public MaxedAmount(String digit, String maxDigit, String unit) {
            this.digit = digit;
            this.maxDigit = maxDigit;
            this.unit = unit;
        }

        public String toString() {
            return "MaxedAmount[" + "digit=" + this.digit + "," + "maxDigit=" + this.maxDigit + "," + "unit=" + this.unit + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.digit != null ? this.digit.hashCode() : 0);
            result = 31 * result + (this.maxDigit != null ? this.maxDigit.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((MaxedAmount)arg0).digit, this.digit)) {
                return false;
            }
            if (!Objects.equals(((MaxedAmount)arg0).maxDigit, this.maxDigit)) {
                return false;
            }
            return Objects.equals(((MaxedAmount)arg0).unit, this.unit);
            {
            }
        }

        public String digit() {
            return this.digit;
        }

        public String maxDigit() {
            return this.maxDigit;
        }

        public String unit() {
            return this.unit;
        }
    }

    public static final class Amount {
        private final String digit;
        private final String unit;

        public Amount(String digit, String unit) {
            this.digit = digit;
            this.unit = unit;
        }

        public String toString() {
            return "Amount[" + "digit=" + this.digit + "," + "unit=" + this.unit + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.digit != null ? this.digit.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Amount)arg0).digit, this.digit)) {
                return false;
            }
            return Objects.equals(((Amount)arg0).unit, this.unit);
            {
            }
        }

        public String digit() {
            return this.digit;
        }

        public String unit() {
            return this.unit;
        }
    }
}

