/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.core.features.ActivityState;
import appeng.core.features.ItemStackSrc;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.parts.PartType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemPart
extends AEBaseItem
implements IPartItem,
IItemGroup {
    private static final int INITIAL_REGISTERED_CAPACITY = PartType.values().length;
    private static final Comparator<Map.Entry<Integer, PartTypeWithVariant>> REGISTERED_COMPARATOR = new RegisteredComparator();
    public static ItemPart instance;
    private final Map<Integer, PartTypeWithVariant> registered = new HashMap<Integer, PartTypeWithVariant>(INITIAL_REGISTERED_CAPACITY);

    public ItemPart() {
        this.func_77627_a(true);
        instance = this;
    }

    @Nonnull
    public final ItemStackSrc createPart(PartType mat) {
        Preconditions.checkNotNull((Object)((Object)mat));
        return this.createPart(mat, 0);
    }

    @Nonnull
    public ItemStackSrc createPart(PartType mat, AEColor color) {
        Preconditions.checkNotNull((Object)((Object)mat));
        Preconditions.checkNotNull((Object)((Object)color));
        int varID = color.ordinal();
        return this.createPart(mat, varID);
    }

    @Nonnull
    private ItemStackSrc createPart(PartType mat, int varID) {
        assert (mat != null);
        assert (varID >= 0);
        for (PartTypeWithVariant p : this.registered.values()) {
            if (p.part != mat || p.variant != varID) continue;
            throw new IllegalStateException("Cannot create the same material twice...");
        }
        boolean enabled = mat.isEnabled();
        int partDamage = mat.getBaseDamage() + varID;
        ActivityState state = ActivityState.from(enabled);
        ItemStackSrc output = new ItemStackSrc(this, partDamage, state);
        PartTypeWithVariant pti = new PartTypeWithVariant(mat, varID);
        this.processMetaOverlap(enabled, partDamage, mat, pti);
        return output;
    }

    private void processMetaOverlap(boolean enabled, int partDamage, PartType mat, PartTypeWithVariant pti) {
        assert (partDamage >= 0);
        assert (mat != null);
        assert (pti != null);
        PartTypeWithVariant registeredPartType = this.registered.get(partDamage);
        if (registeredPartType != null) {
            throw new IllegalStateException("Meta Overlap detected with type " + (Object)((Object)mat) + " and damage " + partDamage + ". Found " + registeredPartType + " there already.");
        }
        if (enabled) {
            this.registered.put(partDamage, pti);
        }
    }

    public int getDamageByType(PartType t) {
        Preconditions.checkNotNull((Object)((Object)t));
        for (Map.Entry<Integer, PartTypeWithVariant> pt : this.registered.entrySet()) {
            if (pt.getValue().part != t) continue;
            return pt.getKey();
        }
        return -1;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        PartType typeByStack = this.getTypeByStack(heldItem);
        if (typeByStack == PartType.INVALID_TYPE) {
            return EnumActionResult.FAIL;
        }
        if (player.func_70093_af() && typeByStack == PartType.IDENTITY_ANNIHILATION_PLANE) {
            ItemStack newPlane = new ItemStack((Item)this, heldItem.func_190916_E(), PartType.ANNIHILATION_PLANE.getBaseDamage());
            newPlane.func_77966_a(Enchantments.field_185306_r, 1);
            player.func_184611_a(hand, newPlane);
            return EnumActionResult.SUCCESS;
        }
        return AEApi.instance().partHelper().placeBus(player.func_184586_b(hand), pos, side, player, hand, w);
    }

    @Nonnull
    public String func_77667_c(ItemStack is) {
        Preconditions.checkNotNull((Object)is);
        return "item.appliedenergistics2.multi_part." + this.getTypeByStack(is).getUnlocalizedName().toLowerCase();
    }

    public String func_77653_i(ItemStack is) {
        PartType pt = this.getTypeByStack(is);
        if (pt.isCable()) {
            AEColor[] variants = AEColor.values();
            int itemDamage = is.func_77952_i();
            PartTypeWithVariant registeredPartType = this.registered.get(itemDamage);
            if (registeredPartType != null) {
                return super.func_77653_i(is) + " - " + variants[registeredPartType.variant].toString();
            }
        }
        if (pt.getExtraName() != null) {
            return super.func_77653_i(is) + " - " + pt.getExtraName().getLocal();
        }
        return super.func_77653_i(is);
    }

    @Override
    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        ArrayList<Map.Entry<Integer, PartTypeWithVariant>> types = new ArrayList<Map.Entry<Integer, PartTypeWithVariant>>(this.registered.entrySet());
        Collections.sort(types, REGISTERED_COMPARATOR);
        for (Map.Entry entry : types) {
            itemStacks.add((Object)new ItemStack((Item)this, 1, ((Integer)entry.getKey()).intValue()));
        }
    }

    @Override
    protected void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        if (this.getTypeByStack(stack) == PartType.ANNIHILATION_PLANE) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            if (enchantments.isEmpty()) {
                lines.add(GuiText.CanBeEnchanted.getLocal());
            } else {
                lines.add(GuiText.IncreasedEnergyUseFromEnchants.getLocal());
            }
        }
        if (this.getTypeByStack(stack) == PartType.IDENTITY_ANNIHILATION_PLANE) {
            lines.add(GuiText.Deprecated.getLocal());
        }
    }

    public int func_77619_b() {
        return 10;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getTypeByStack(stack) == PartType.ANNIHILATION_PLANE;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185306_r || enchantment == Enchantments.field_185305_q;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.getTypeByStack(stack) == PartType.ANNIHILATION_PLANE;
    }

    @Nonnull
    public PartType getTypeByStack(ItemStack is) {
        Preconditions.checkNotNull((Object)is);
        PartTypeWithVariant pt = this.registered.get(is.func_77952_i());
        if (pt != null) {
            return pt.part;
        }
        return PartType.INVALID_TYPE;
    }

    @Nullable
    public IPart createPartFromItemStack(ItemStack is) {
        PartType type = this.getTypeByStack(is);
        Class<? extends IPart> part = type.getPart();
        if (part == null) {
            return null;
        }
        try {
            if (type.getConstructor() == null) {
                type.setConstructor(part.getConstructor(ItemStack.class));
            }
            return type.getConstructor().newInstance(is);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to construct IBusPart from IBusItem : " + part.getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to construct IBusPart from IBusItem : " + part.getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to construct IBusPart from IBusItem : " + part.getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to construct IBusPart from IBusItem : " + part.getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
    }

    public int variantOf(int itemDamage) {
        PartTypeWithVariant registeredPartType = this.registered.get(itemDamage);
        if (registeredPartType != null) {
            return registeredPartType.variant;
        }
        return 0;
    }

    @Override
    @Nullable
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        boolean importBus = false;
        boolean importBusFluids = false;
        boolean exportBus = false;
        boolean exportBusFluids = false;
        boolean group = false;
        PartType u = this.getTypeByStack(is);
        for (ItemStack stack : others) {
            if (stack.func_77973_b() != this) continue;
            PartType pt = this.getTypeByStack(stack);
            switch (pt) {
                case IMPORT_BUS: {
                    importBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
                case FLUID_IMPORT_BUS: {
                    importBusFluids = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
                case EXPORT_BUS: {
                    exportBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
                case FLUID_EXPORT_BUS: {
                    exportBusFluids = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
            }
        }
        if (group && importBus && exportBus && (u == PartType.IMPORT_BUS || u == PartType.EXPORT_BUS)) {
            return GuiText.IOBuses.getUnlocalized();
        }
        if (group && importBusFluids && exportBusFluids && (u == PartType.FLUID_IMPORT_BUS || u == PartType.FLUID_EXPORT_BUS)) {
            return GuiText.IOBusesFluids.getUnlocalized();
        }
        return null;
    }

    public void registerOreDicts() {
        for (PartTypeWithVariant mt : ImmutableSet.copyOf(this.registered.values())) {
            String[] names;
            if (mt.part.getOreName() == null) continue;
            for (String name : names = mt.part.getOreName().split(",")) {
                OreDictionary.registerOre((String)name, (ItemStack)new ItemStack((Item)this, 1, mt.part.getBaseDamage() + mt.variant));
            }
        }
    }

    private static final class PartTypeWithVariant {
        private final PartType part;
        private final int variant;

        private PartTypeWithVariant(PartType part, int variant) {
            assert (part != null);
            assert (variant >= 0);
            this.part = part;
            this.variant = variant;
        }

        public String toString() {
            return "PartTypeWithVariant{part=" + (Object)((Object)this.part) + ", variant=" + this.variant + '}';
        }
    }

    private static final class RegisteredComparator
    implements Comparator<Map.Entry<Integer, PartTypeWithVariant>> {
        private RegisteredComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, PartTypeWithVariant> o1, Map.Entry<Integer, PartTypeWithVariant> o2) {
            String string2;
            String string1 = o1.getValue().part.name();
            int comparedString = string1.compareTo(string2 = o2.getValue().part.name());
            if (comparedString == 0) {
                return Integer.compare(o1.getKey(), o2.getKey());
            }
            return comparedString;
        }
    }
}

