/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.Upgrades;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.materials.ItemMaterial;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ToolWirelessTerminal
extends AEBasePoweredItem
implements IWirelessTermHandler,
IBauble {
    int magnetTick;

    public ToolWirelessTerminal() {
        super(AEConfig.instance().getWirelessTerminalBattery());
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        AEApi.instance().registries().wireless().openWirelessTerminalGui(player.func_184586_b(hand), w, player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = Platform.openNbtData(stack);
            if (tag != null) {
                String encKey = tag.func_74779_i("encryptionKey");
                if (encKey == null || encKey.isEmpty()) {
                    lines.add(TextFormatting.RED + GuiText.Unlinked.getLocal());
                } else {
                    lines.add(TextFormatting.GREEN + GuiText.Linked.getLocal());
                }
            }
        } else {
            lines.add(I18n.func_74838_a((String)"AppEng.GuiITooltip.Unlinked"));
        }
    }

    @Override
    public boolean canHandle(ItemStack is) {
        return AEApi.instance().definitions().items().wirelessTerminal().isSameAs(is);
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    @Override
    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData(target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData(target).func_74737_b());
        return out;
    }

    @Override
    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData(item);
        return tag.func_74779_i("encryptionKey");
    }

    @Override
    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData(item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (Platform.isServer()) {
            this.magnetLogic(stack, worldIn, entityIn);
        }
    }

    @Override
    public IGuiHandler getGuiHandler(ItemStack is) {
        return GuiBridge.GUI_WIRELESS_TERM;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.TRINKET;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (Platform.isServer()) {
            this.magnetLogic(itemstack, player.field_70170_p, (Entity)player);
        }
    }

    public void magnetLogic(ItemStack stack, World worldIn, Entity entityIn) {
        if (entityIn instanceof EntityPlayer) {
            ++this.magnetTick;
            if (this.magnetTick % 5 != 0) {
                return;
            }
            this.magnetTick = 0;
            if (!entityIn.func_70093_af()) {
                NBTTagCompound upgradeNBT = Platform.openNbtData(stack).func_74775_l("upgrades");
                ItemStackHandler siu = new ItemStackHandler(0);
                siu.deserializeNBT(upgradeNBT);
                for (int s = 0; s < siu.getSlots(); ++s) {
                    boolean isFuzzy;
                    ItemStack is = siu.getStackInSlot(s);
                    if (!AEApi.instance().definitions().materials().cardMagnet().isSameAs(is)) continue;
                    NBTTagCompound tag = is.func_77978_p();
                    if (tag != null && tag.func_74764_b("enabled") && !tag.func_74767_n("enabled")) {
                        return;
                    }
                    ItemMaterial im = (ItemMaterial)is.func_77973_b();
                    CellConfig c = (CellConfig)im.getConfigInventory(is);
                    CellUpgrades u = (CellUpgrades)im.getUpgradesInventory(is);
                    FuzzyMode fz = null;
                    boolean bl = isFuzzy = u.getInstalledUpgrades(Upgrades.FUZZY) == 1;
                    if (isFuzzy) {
                        fz = im.getFuzzyMode(is);
                    }
                    boolean inverted = u.getInstalledUpgrades(Upgrades.INVERTER) == 1;
                    List ei = worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB(entityIn.field_70165_t - 5.0, entityIn.field_70163_u - 5.0, entityIn.field_70161_v - 5.0, entityIn.field_70165_t + 5.0, entityIn.field_70163_u + 5.0, entityIn.field_70161_v + 5.0));
                    boolean emptyFilter = true;
                    for (EntityItem i : ei) {
                        NBTTagCompound itemTag;
                        if (i.field_70128_L || (itemTag = i.getEntityData()).func_74764_b("PreventRemoteMovement") || i.func_145800_j() != null && i.func_145800_j().equals(entityIn.func_70005_c_()) && i.func_174874_s()) continue;
                        boolean matched = false;
                        for (int ss = 0; ss < c.getSlots(); ++ss) {
                            ItemStack filter = c.getStackInSlot(ss);
                            if (filter.func_190926_b()) continue;
                            emptyFilter = false;
                            if (isFuzzy) {
                                if (!Platform.itemComparisons().isFuzzyEqualItem(filter, i.func_92059_d(), fz)) continue;
                                matched = true;
                                break;
                            }
                            if (!Platform.itemComparisons().isSameItem(filter, i.func_92059_d())) continue;
                            matched = true;
                            break;
                        }
                        if (emptyFilter) {
                            this.teleportItem(i, entityIn);
                            continue;
                        }
                        if (matched && !inverted) {
                            this.teleportItem(i, entityIn);
                            continue;
                        }
                        if (matched || !inverted) continue;
                        this.teleportItem(i, entityIn);
                    }
                }
            }
        }
    }

    private void teleportItem(EntityItem i, Entity entityIn) {
        i.field_70179_y = 0.0;
        i.field_70181_x = 0.0;
        i.field_70159_w = 0.0;
        i.func_70107_b(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
    }
}

