/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.SecurityCache;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

public class NetworkInventoryHandler<T extends IAEStack<T>>
implements IMEInventoryHandler<T> {
    private static final ThreadLocal<Deque> DEPTH_MOD = new ThreadLocal();
    private static final ThreadLocal<Deque> DEPTH_SIM = new ThreadLocal();
    private static final Comparator<Integer> PRIORITY_SORTER = (o1, o2) -> Integer.compare(o2, o1);
    private static int currentPass = 0;
    private final IStorageChannel<T> myChannel;
    private final SecurityCache security;
    private final NavigableMap<Integer, List<IMEInventoryHandler<T>>> craftingPriorityInventory;
    private final NavigableMap<Integer, List<IMEInventoryHandler<T>>> priorityInventory;
    private final NavigableMap<Integer, List<IMEInventoryHandler<T>>> stickyPriorityInventory;
    private int myPass = 0;

    public NetworkInventoryHandler(IStorageChannel<T> chan, SecurityCache security) {
        this.myChannel = chan;
        this.security = security;
        this.priorityInventory = new TreeMap<Integer, List<IMEInventoryHandler<T>>>(PRIORITY_SORTER);
        this.stickyPriorityInventory = new TreeMap<Integer, List<IMEInventoryHandler<T>>>(PRIORITY_SORTER);
        this.craftingPriorityInventory = new TreeMap<Integer, List<IMEInventoryHandler<T>>>(PRIORITY_SORTER);
    }

    public void addNewStorage(IMEInventoryHandler<T> h) {
        int priority = h.getPriority();
        NavigableMap<Integer, List<IMEInventoryHandler<T>>> list = h instanceof ICraftingGrid ? this.craftingPriorityInventory : (h.isSticky() ? this.stickyPriorityInventory : this.priorityInventory);
        list.computeIfAbsent(priority, $ -> new ArrayList()).add(h);
    }

    @Override
    public T injectItems(T input, Actionable type, IActionSource src) {
        IMEInventoryHandler inv;
        Iterator ii;
        if (this.diveList(this, type)) {
            return input;
        }
        if (this.testPermission(src, SecurityPermissions.INJECT)) {
            this.surface(this, type);
            return input;
        }
        for (List invList : this.craftingPriorityInventory.values()) {
            Iterator ii2 = invList.iterator();
            while (ii2.hasNext() && input != null) {
                IMEInventoryHandler inv2 = (IMEInventoryHandler)ii2.next();
                if (!inv2.canAccept(input) || !inv2.isPrioritized(input) && inv2.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv2.injectItems(input, type, src);
            }
        }
        if (input == null) {
            this.surface(this, type);
            return input;
        }
        boolean stickyInventoryFound = false;
        for (List stickyInvList : this.stickyPriorityInventory.values()) {
            ii = stickyInvList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
                stickyInventoryFound = true;
            }
        }
        if (stickyInventoryFound) {
            this.surface(this, type);
            return input;
        }
        for (List invList : this.priorityInventory.values()) {
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
            }
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(2) || !inv.canAccept(input) || inv.isPrioritized(input)) continue;
                input = inv.injectItems(input, type, src);
            }
        }
        this.surface(this, type);
        return input;
    }

    private boolean diveList(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        Deque cDepth = this.getDepth(type);
        if (cDepth.contains(networkInventoryHandler)) {
            return true;
        }
        cDepth.push(this);
        return false;
    }

    private boolean testPermission(IActionSource src, SecurityPermissions permission) {
        if (src.player().isPresent()) {
            return !this.security.hasPermission(src.player().get(), permission);
        }
        if (src.machine().isPresent() && this.security.isAvailable()) {
            IGridNode n = src.machine().get().getActionableNode();
            if (n == null) {
                return true;
            }
            IGrid gn = n.getGrid();
            if (gn != this.security.getGrid()) {
                ISecurityGrid sg = (ISecurityGrid)gn.getCache(ISecurityGrid.class);
                int playerID = sg.getOwner();
                return !this.security.hasPermission(playerID, permission);
            }
        }
        return false;
    }

    private void surface(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        if (this.getDepth(type).pop() != this) {
            throw new IllegalStateException("Invalid Access to Networked Storage API detected.");
        }
    }

    private Deque getDepth(Actionable type) {
        ThreadLocal<Deque> depth = type == Actionable.MODULATE ? DEPTH_MOD : DEPTH_SIM;
        ArrayDeque s = depth.get();
        if (s == null) {
            s = new ArrayDeque();
            depth.set(s);
        }
        return s;
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        if (this.diveList(this, mode)) {
            return null;
        }
        if (this.testPermission(src, SecurityPermissions.EXTRACT)) {
            this.surface(this, mode);
            return null;
        }
        Iterator i = this.priorityInventory.descendingMap().values().iterator();
        T output = request.copy();
        request = request.copy();
        output.setStackSize(0L);
        long req = request.getStackSize();
        while (i.hasNext()) {
            List invList = (List)i.next();
            Iterator ii = invList.iterator();
            while (ii.hasNext() && output.getStackSize() < req) {
                IMEInventoryHandler inv = (IMEInventoryHandler)ii.next();
                request.setStackSize(req - output.getStackSize());
                output.add(inv.extractItems(request, mode, src));
            }
        }
        for (List invList : this.stickyPriorityInventory.descendingMap().values()) {
            Iterator jj = invList.iterator();
            while (jj.hasNext() && output.getStackSize() < req) {
                IMEInventoryHandler inv = (IMEInventoryHandler)jj.next();
                request.setStackSize(req - output.getStackSize());
                output.add(inv.extractItems(request, mode, src));
            }
        }
        this.surface(this, mode);
        if (output.getStackSize() <= 0L) {
            return null;
        }
        return output;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        if (this.diveIteration(this, Actionable.SIMULATE)) {
            return out;
        }
        this.iterateInventories(out, this.priorityInventory);
        this.iterateInventories(out, this.stickyPriorityInventory);
        this.iterateInventories(out, this.craftingPriorityInventory);
        this.surface(this, Actionable.SIMULATE);
        return out;
    }

    private void iterateInventories(IItemList<T> out, NavigableMap<Integer, List<IMEInventoryHandler<T>>> map) {
        for (List i : map.values()) {
            for (IMEInventoryHandler j : i) {
                j.getAvailableItems(out);
            }
        }
    }

    private boolean diveIteration(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        Deque cDepth = this.getDepth(type);
        if (cDepth.isEmpty()) {
            this.myPass = ++currentPass;
        } else {
            if (currentPass == this.myPass) {
                return true;
            }
            this.myPass = currentPass;
        }
        cDepth.push(this);
        return false;
    }

    @Override
    public IStorageChannel<T> getChannel() {
        return this.myChannel;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(T input) {
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

