/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.automation.PartAnnihilationPlane;
import appeng.parts.automation.PlaneModels;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class PartIdentityAnnihilationPlane
extends PartAnnihilationPlane {
    private static final PlaneModels MODELS = new PlaneModels("part/identity_annihilation_plane_", "part/identity_annihilation_plane_on_");
    private static final float SILK_TOUCH_FACTOR = 16.0f;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartIdentityAnnihilationPlane(ItemStack is) {
        super(is);
    }

    @Override
    protected float calculateEnergyUsage(WorldServer w, BlockPos pos, List<ItemStack> items) {
        float requiredEnergy = super.calculateEnergyUsage(w, pos, items);
        return requiredEnergy * 16.0f;
    }

    @Override
    protected List<ItemStack> obtainBlockDrops(WorldServer w, BlockPos pos) {
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)w);
        IBlockState state = w.func_180495_p(pos);
        if (state.func_177230_c().canSilkHarvest((World)w, pos, state, (EntityPlayer)fakePlayer)) {
            ArrayList<ItemStack> out = new ArrayList<ItemStack>(1);
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            if (item != Items.field_190931_a) {
                int meta = 0;
                if (item.func_77614_k()) {
                    meta = state.func_177230_c().func_176201_c(state);
                }
                ItemStack itemstack = new ItemStack(item, 1, meta);
                out.add(itemstack);
            }
            return out;
        }
        return super.obtainBlockDrops(w, pos);
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        TileEntity tile = this.getTile();
        if (tile instanceof IPartHost) {
            IPartHost host = (IPartHost)tile;
            host.removePart(this.getSide(), false);
            ItemStack itemStack = AEApi.instance().definitions().parts().annihilationPlane().maybeStack(1).orElse(ItemStack.field_190927_a);
            itemStack.func_77966_a(Enchantments.field_185306_r, 1);
            host.addPart(itemStack, this.getSide(), player, hand);
            return true;
        }
        return false;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.getConnections(), this.isPowered(), this.isActive());
    }
}

