/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class EnchantmentUtil {
    private EnchantmentUtil() {
    }

    private static Map<Enchantment, Integer> deserializeEnchantments(NBTTagList tagList) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compoundtag = tagList.func_150305_b(i);
            Enchantment enchantmentByID = Enchantment.func_185262_c((int)EnchantmentUtil.getEnchantmentId(compoundtag));
            if (enchantmentByID == null) continue;
            map.put(enchantmentByID, EnchantmentUtil.getEnchantmentLevel(compoundtag));
        }
        return map;
    }

    private static int getEnchantmentId(NBTTagCompound tagCompound) {
        return tagCompound.func_74762_e("id");
    }

    private static int getEnchantmentLevel(NBTTagCompound tagCompound) {
        return Math.max(0, Math.min(255, tagCompound.func_74762_e("lvl")));
    }

    private static NBTTagCompound storeEnchantment(int id, int level) {
        NBTTagCompound compoundtag = new NBTTagCompound();
        compoundtag.func_74777_a("id", (short)id);
        compoundtag.func_74777_a("lvl", (short)level);
        return compoundtag;
    }

    public static Map<Enchantment, Integer> getEnchantments(NBTTagCompound data) {
        NBTTagList list;
        Map<Enchantment, Integer> enchants;
        if (data.func_150297_b("Enchantments", 9) && !(enchants = EnchantmentUtil.deserializeEnchantments(list = data.func_150295_c("Enchantments", 10))).isEmpty()) {
            return enchants;
        }
        return new HashMap<Enchantment, Integer>();
    }

    public static void setEnchantments(NBTTagCompound tag, Map<Enchantment, Integer> enchantments) {
        NBTTagList enchantList = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int level = entry.getValue();
            enchantList.func_74742_a((NBTBase)EnchantmentUtil.storeEnchantment(Enchantment.func_185258_b((Enchantment)enchantment), level));
        }
        tag.func_74782_a("Enchantments", (NBTBase)enchantList);
    }
}

