/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import its_meow.betteranimalsplus.common.entity.EntityAnimalWithTypes;
import its_meow.betteranimalsplus.common.entity.IVariantTypes;
import its_meow.betteranimalsplus.common.entity.ai.WaterfowlNavigator;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModSoundEvents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class EntityGoose
extends EntityAnimalWithTypes {
    public int attacksLeft = 0;
    public int lastAttackTime = 0;
    protected final Set<UUID> dislikedPlayers = new HashSet<UUID>();
    private int eatTicks;
    private static final Predicate<EntityItem> ITEM_SELECTOR = item -> !item.func_174874_s() && !item.field_70128_L;
    public int timeUntilNextEgg;
    public static String[] pickupBlockList;

    public EntityGoose(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_98053_h(true);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new WaterfowlNavigator((EntityLiving)this, worldIn);
    }

    protected float func_189749_co() {
        return 0.95f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4){

            public boolean func_75250_a() {
                return this.field_75267_a.func_70638_az() == null && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, (Set)Sets.newHashSet((Object[])new Item[]{Items.field_151080_bb, Items.field_151014_N, Items.field_185163_cU, Items.field_151081_bc, Items.field_151025_P})));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.1, false){

            public void func_75249_e() {
                EntityGoose.this.attacksLeft = this.field_75441_b.func_70681_au().nextInt(4) + 1;
                super.func_75249_e();
            }

            public boolean func_75250_a() {
                return super.func_75250_a() && this.field_75441_b.field_70173_aa - EntityGoose.this.lastAttackTime > 150 && EntityGoose.this.getTypeNumber() != 1;
            }

            public boolean func_75253_b() {
                return EntityGoose.this.attacksLeft > 0 && super.func_75253_b();
            }

            protected void func_190102_a(EntityLivingBase p_190102_1_, double p_190102_2_) {
                if (EntityGoose.this.attacksLeft > 0) {
                    super.func_190102_a(p_190102_1_, p_190102_2_);
                } else {
                    this.func_75251_c();
                }
            }

            public void func_75251_c() {
                super.func_75251_c();
                if (EntityGoose.this.attacksLeft <= 0) {
                    this.field_75441_b.func_70624_b(null);
                }
            }
        });
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]){

            public boolean func_75250_a() {
                return super.func_75250_a() && EntityGoose.this.getTypeNumber() != 1;
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DislikeTargetGoal(this){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && EntityGoose.this.getTypeNumber() != 1;
            }
        });
    }

    public void func_70636_d() {
        ItemStack itemstack;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.func_70613_aW() && (itemstack = this.func_184582_a(EntityEquipmentSlot.MAINHAND)).func_77973_b() instanceof ItemFood && this.func_70638_az() == null) {
            ++this.eatTicks;
            if (this.eatTicks > 200) {
                ItemStack itemstack1;
                if (itemstack.func_77973_b() == Items.field_151025_P) {
                    this.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), 900, 1, false, true));
                }
                if (!(itemstack1 = itemstack.func_77950_b(this.field_70170_p, (EntityLivingBase)this)).func_190926_b()) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack1);
                }
                this.eatTicks = 0;
            } else if (this.eatTicks > 160 && this.field_70146_Z.nextFloat() < 0.1f) {
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_70099_a(new ItemStack((Item)(this.func_70681_au().nextInt(128) == 0 ? ModItems.GOLDEN_GOOSE_EGG : ModItems.GOOSE_EGG)), 0.5f);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack stack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            if (!stack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    if (stack.func_77981_g()) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + this.func_70040_Z().field_72450_a / 2.0, this.field_70163_u, this.field_70161_v + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()});
                        continue;
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + this.func_70040_Z().field_72450_a / 2.0, this.field_70163_u, this.field_70161_v + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public void func_70624_b(EntityLivingBase entity) {
        UUID uuid;
        super.func_70624_b(entity);
        if (entity instanceof EntityPlayer && !this.dislikedPlayers.contains(uuid = ((EntityPlayer)entity).func_146103_bH().getId())) {
            this.dislikedPlayers.add(uuid);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        if (this.attacksLeft > 0) {
            --this.attacksLeft;
        }
        this.lastAttackTime = this.field_70173_aa;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() != null && source.func_76346_g() == this.func_70638_az()) {
            this.lastAttackTime = 0;
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean func_175448_a(ItemStack newStack) {
        ItemStack oldStack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        return !this.isPickupBlacklisted(newStack.func_77973_b()) && (oldStack.func_190926_b() || this.eatTicks == 0 && newStack.func_77973_b() instanceof ItemFood && !(oldStack.func_77973_b() instanceof ItemFood));
    }

    public boolean isPickupBlacklisted(Item item) {
        String id = item.getRegistryName().toString();
        for (String itemsId : pickupBlockList) {
            if (!(itemsId.startsWith("ore:") ? OreDictionary.getOres((String)itemsId.substring(4)).stream().anyMatch(itemStack -> itemStack.func_77973_b() == item) : id.equals(itemsId))) continue;
            return true;
        }
        return false;
    }

    private void dropItemGoose(ItemStack stack) {
        if (!stack.func_190926_b() && !this.field_70170_p.field_72995_K) {
            EntityItem itementity = new EntityItem(this.field_70170_p, this.field_70165_t + this.func_70040_Z().field_72450_a, this.field_70163_u + 1.0, this.field_70161_v + this.func_70040_Z().field_72449_c, stack);
            itementity.func_174867_a(40);
            this.field_70170_p.func_72838_d((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stack) {
        EntityItem entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.field_70170_p.func_72838_d((Entity)entity);
    }

    public SoundEvent func_184639_G() {
        return ModSoundEvents.GOOSE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSoundEvents.GOOSE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.GOOSE_DEATH;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        if (this.func_175448_a(stack)) {
            int i = stack.func_190916_E();
            if (i > 1) {
                this.spawnItem(stack.func_77979_a(i - 1));
            }
            this.dropItemGoose(this.func_184582_a(EntityEquipmentSlot.MAINHAND));
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack.func_77979_a(1));
            this.field_82174_bp[EntityEquipmentSlot.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, stack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        NBTTagCompound c = super.func_189511_e(compound);
        NBTTagList list = new NBTTagList();
        for (UUID uuid : this.dislikedPlayers) {
            list.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        c.func_74782_a("disliked_players", (NBTBase)list);
        return c;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        compound.func_150295_c("disliked_players", 8).forEach(nbt -> this.dislikedPlayers.add(UUID.fromString(((NBTTagString)nbt).func_150285_a_())));
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return this.initData(super.func_180482_a(difficulty, livingdata), this.func_70681_au().nextInt(2) + 2);
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos(this.field_70165_t, Math.floor(this.field_70163_u), this.field_70161_v);
        Block downBlock = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        return (downBlock == Blocks.field_150349_c && EntityGoose.nearWater(this.field_70170_p, pos) || downBlock == Blocks.field_150355_j) && this.field_70170_p.func_175699_k(pos) > 8 && this.field_70170_p.func_175623_d(pos);
    }

    protected static boolean nearWater(World world, BlockPos pos) {
        int i = 12;
        int j = 2;
        BlockPos.MutableBlockPos newpos = new BlockPos.MutableBlockPos();
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        newpos.func_189533_g((Vec3i)pos).func_177982_a(i1, k - 1, j1);
                        if (newpos.func_177958_n() >> 4 == pos.func_177958_n() >> 4 && newpos.func_177952_p() >> 4 == pos.func_177952_p() >> 4 && world.func_180495_p((BlockPos)newpos).func_177230_c() == Blocks.field_150355_j) {
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    @Override
    public int getVariantMax() {
        return 3;
    }

    @Override
    protected IVariantTypes getBaseChild() {
        return new EntityGoose(this.field_70170_p);
    }

    @Override
    protected String getContainerName() {
        return "goose";
    }

    public class DislikeTargetGoal
    extends EntityAITarget {
        protected EntityGoose goose;
        protected EntityPlayer targetEntity;

        public DislikeTargetGoal(EntityGoose goose) {
            super((EntityCreature)goose, false);
            this.goose = goose;
        }

        public boolean func_75250_a() {
            if (this.goose.dislikedPlayers.size() > 0 && this.goose.func_70638_az() == null && this.goose.field_70173_aa - this.goose.lastAttackTime > 150) {
                this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), player -> 1.0, entity -> this.func_75296_a((EntityLivingBase)entity, false));
                return this.targetEntity != null;
            }
            return false;
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b((EntityLivingBase)this.targetEntity);
            super.func_75249_e();
        }

        protected boolean func_75296_a(EntityLivingBase target, boolean includeInvincibles) {
            return target instanceof EntityPlayer && EntityGoose.this.dislikedPlayers.contains(((EntityPlayer)target).func_146103_bH().getId());
        }
    }

    public class FindItemsGoal
    extends EntityAIBase {
        public FindItemsGoal() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (!EntityGoose.this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                return false;
            }
            if (EntityGoose.this.func_70638_az() == null && EntityGoose.this.func_70643_av() == null) {
                if (EntityGoose.this.func_70681_au().nextInt(10) != 0) {
                    return false;
                }
                List list = EntityGoose.this.field_70170_p.func_175647_a(EntityItem.class, EntityGoose.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty() && EntityGoose.this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b();
            }
            return false;
        }

        public void func_75246_d() {
            List list = EntityGoose.this.field_70170_p.func_175647_a(EntityItem.class, EntityGoose.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            ItemStack itemstack = EntityGoose.this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            if (itemstack.func_190926_b() && !list.isEmpty()) {
                EntityGoose.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = EntityGoose.this.field_70170_p.func_175647_a(EntityItem.class, EntityGoose.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityGoose.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

