/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.biolib.objects;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import c4.conarm.lib.traits.AbstractArmorTrait;
import java.util.ArrayList;
import java.util.Map;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public class ArmorHelper {
    public static String CORE = "core";
    public static String PLATES = "plates";
    public static String TRIM = "trim";

    public static void addArmorMat(Material material, float toughness) {
        HeadMaterialStats head = (HeadMaterialStats)material.getStats("head");
        HandleMaterialStats handle = (HandleMaterialStats)material.getStats("handle");
        ExtraMaterialStats extra = (ExtraMaterialStats)material.getStats("extra");
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new CoreMaterialStats((float)head.durability / 30.0f, head.attack * 2.1f), (IMaterialStats[])new IMaterialStats[]{new PlatesMaterialStats(handle.modifier, (float)handle.durability / 18.0f, toughness), new TrimMaterialStats((float)extra.extraDurability / 16.0f)});
    }

    public static void addArmorMat(Material material, float toughness, AbstractArmorTrait[] traits) {
        ArmorHelper.addArmorMat(material, toughness);
        TinkerRegistry.addMaterialTrait((Material)material, (ITrait)traits[0], (String)ArmorMaterialType.CORE);
        TinkerRegistry.addMaterialTrait((Material)material, (ITrait)traits[1], (String)ArmorMaterialType.PLATES);
        TinkerRegistry.addMaterialTrait((Material)material, (ITrait)traits[2], (String)ArmorMaterialType.TRIM);
    }

    public static void addArmorMat(Material material, float toughness, Map<String, ArrayList<AbstractArmorTrait>> traits) {
        ArmorHelper.addArmorMat(material, toughness);
        for (Map.Entry<String, ArrayList<AbstractArmorTrait>> mapTrait : traits.entrySet()) {
            for (AbstractArmorTrait trait : mapTrait.getValue()) {
                TinkerRegistry.addMaterialTrait((Material)material, (ITrait)trait, (String)mapTrait.getKey());
            }
        }
    }
}

