/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tile;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.tile.TileBC_Neptune;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TilePowerConsumerTester
extends TileBC_Neptune
implements IMjReceiver,
ITickable,
IDebuggable {
    private final MjCapabilityHelper mjCaps = new MjCapabilityHelper(this);
    private long lastReceived;
    private long nextTickReceived;
    private long lastTickReceived;
    private long totalReceived;

    public TilePowerConsumerTester() {
        this.caps.addProvider(this.mjCaps);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lastReceived = nbt.func_74763_f("last");
        this.nextTickReceived = nbt.func_74763_f("nt");
        this.lastTickReceived = nbt.func_74763_f("lt");
        this.totalReceived = nbt.func_74763_f("total");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74772_a("last", this.lastReceived);
        nbt.func_74772_a("nt", this.nextTickReceived);
        nbt.func_74772_a("lt", this.lastTickReceived);
        nbt.func_74772_a("total", this.totalReceived);
        return nbt;
    }

    public void func_73660_a() {
        this.lastTickReceived = this.nextTickReceived;
        this.nextTickReceived = 0L;
    }

    @Override
    public boolean canConnect(IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        return 100000L * MjAPI.MJ;
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        if (!simulate) {
            this.lastReceived = microJoules;
            this.nextTickReceived += microJoules;
            this.totalReceived += microJoules;
        }
        return 0L;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("");
        left.add("Last received = " + LocaleUtil.localizeMj(this.lastReceived));
        left.add("Tick received = " + LocaleUtil.localizeMj(this.lastTickReceived));
        left.add("Total received = " + LocaleUtil.localizeMj(this.totalReceived));
    }
}

