/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.client.gui;

import buildcraft.api.core.render.ISprite;
import buildcraft.energy.tile.TileDynamoMJ;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.ledger.Ledger_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import net.minecraft.util.ResourceLocation;

public class LedgerDynamoMJ
extends Ledger_Neptune {
    private static final int OVERLAY_COLOUR = -2855905;
    private static final int HEADER_COLOUR = -1980113;
    private static final int SUB_HEADER_COLOUR = -5591112;
    private static final int TEXT_COLOUR = -16777216;
    public final TileDynamoMJ engine;

    public LedgerDynamoMJ(BuildCraftGui gui, TileDynamoMJ engine, boolean expandPositive) {
        super(gui, -2855905, expandPositive);
        this.engine = engine;
        this.title = "gui.power";
        this.appendText(LocaleUtil.localize("gui.currentOutput") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeRfFlow(engine.getCurrentOutput()), -16777216);
        this.appendText(LocaleUtil.localize("gui.stored") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeMj(engine.getMjStored()), -16777216);
        this.appendText(LocaleUtil.localize("gui.heat") + ":", -5591112).setDropShadow(true);
        this.appendText(() -> LocaleUtil.localizeHeat(engine.getHeat()), -16777216);
        this.calculateMaxSize();
        this.setOpenProperty(GuiConfigManager.getOrAddBoolean(new ResourceLocation("buildcraftlib:engine"), "ledger.power.is_open", false));
    }

    @Override
    public int getTitleColour() {
        return -1980113;
    }

    @Override
    protected void drawIcon(double x, double y) {
        ISprite sprite;
        switch (this.engine.getPowerStage()) {
            case OVERHEAT: {
                sprite = BCLibSprites.ENGINE_OVERHEAT;
                break;
            }
            case RED: 
            case YELLOW: {
                sprite = BCLibSprites.ENGINE_WARM;
                break;
            }
            default: {
                sprite = this.engine.isEngineOn() ? BCLibSprites.ENGINE_ACTIVE : BCLibSprites.ENGINE_INACTIVE;
            }
        }
        GuiIcon.draw(sprite, x, y, x + 16.0, y + 16.0);
    }
}

