/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest.quests;

import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.quests.ActiveQuest;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class KillEntityQuest
extends ActiveQuest {
    public Class neededMob;
    public int neededKillCount;
    public boolean returnToQuestGiver;
    public int curKillCount;

    public KillEntityQuest() {
        this.questType = "killEntity";
    }

    public void initCustomData(Class mob, int count, boolean parReturnToQuestGiver) {
        super.initCustomData();
        this.neededMob = mob;
        this.neededKillCount = count;
        this.returnToQuestGiver = parReturnToQuestGiver;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.curState == EnumQuestState.ASSIGNED) {
            if (this.curKillCount >= this.neededKillCount) {
                if (this.returnToQuestGiver) {
                    this.setState(EnumQuestState.CONCLUDING);
                } else {
                    this.setState(EnumQuestState.COMPLETE);
                    System.out.println("quest kill complete");
                }
            }
        } else if (this.curState == EnumQuestState.CONCLUDING) {
            // empty if block
        }
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof LivingDeathEvent) {
            this.deathEvent((LivingDeathEvent)event);
        }
    }

    public void deathEvent(LivingDeathEvent event) {
        Entity source = event.getSource().func_76346_g();
        if (source != null && source.equals((Object)this.playerQuests.getPlayer()) && event.getEntityLiving().getClass().equals(this.neededMob)) {
            ++this.curKillCount;
            this.saveAndSync();
            System.out.println("quest kill inc");
        }
    }

    @Override
    public void load(NBTTagCompound parNBT) {
        super.load(parNBT);
        this.curKillCount = parNBT.func_74762_e("curKillCount");
        this.neededKillCount = parNBT.func_74762_e("neededKillCount");
    }

    @Override
    public void save(NBTTagCompound parNBT) {
        super.save(parNBT);
        parNBT.func_74768_a("curKillCount", this.curKillCount);
        parNBT.func_74768_a("neededKillCount", this.neededKillCount);
    }
}

