/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.grid.block;

import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.grid.block.BlockDataPoint;
import CoroUtil.world.grid.block.BlockStaticDataMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDataGrid {
    public World world;
    public HashMap<Integer, BlockDataPoint> grid;

    public BlockDataGrid(World parWorld) {
        this.world = parWorld;
        this.grid = new HashMap();
    }

    public int getHash(int i, int j, int k) {
        return j & 0xFF | (i & Short.MAX_VALUE) << 8 | (k & Short.MAX_VALUE) << 24 | (i >= 0 ? 0 : Integer.MIN_VALUE) | (k >= 0 ? 0 : 32768);
    }

    public float getBlockStrength(int x, int y, int z) {
        Block blockID = this.world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        return BlockStaticDataMap.getBlockStength(blockID);
    }

    public BlockDataPoint getBlockDataFromNBT(int i, int j, int k, NBTTagCompound nbt) {
        return this.getBlockData(i, j, k, false, false, nbt);
    }

    public BlockDataPoint getBlockData(int i, int j, int k) {
        return this.getBlockData(i, j, k, false, false, null);
    }

    public BlockDataPoint getBlockDataIfExists(int i, int j, int k) {
        return this.getBlockData(i, j, k, false, true, null);
    }

    public BlockDataPoint getBlockData(int i, int j, int k, boolean skipAirCheckOnCreate, boolean onlyIfExists, NBTTagCompound nbt) {
        int hash = this.getHash(i, j, k);
        if (!this.grid.containsKey(hash)) {
            if (!onlyIfExists) {
                if (skipAirCheckOnCreate || !CoroUtilBlock.isAir(nbt != null ? Block.func_149729_e((int)nbt.func_74762_e("blockID")) : this.world.func_180495_p(new BlockPos(i, j, k)).func_177230_c())) {
                    BlockDataPoint newVec = new BlockDataPoint(this, i, j, k);
                    this.grid.put(newVec.hash, newVec);
                    return newVec;
                }
                return null;
            }
            return null;
        }
        return this.grid.get(hash);
    }

    public void removeBlockDataIfRemovable(int i, int j, int k) {
        BlockDataPoint bdp;
        int hash = this.getHash(i, j, k);
        if (this.grid.containsKey(hash) && (bdp = this.grid.get(hash)).isRemovable()) {
            bdp.cleanup();
            this.grid.remove(hash);
        }
    }

    public void removeBlockData(int i, int j, int k) {
        int hash = this.getHash(i, j, k);
        if (this.grid.containsKey(hash)) {
            BlockDataPoint bdp = this.grid.get(hash);
            bdp.cleanup();
            this.grid.remove(hash);
        }
    }

    public void readFromFile() {
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator;
            if (new File(saveFolder + "BlockDataDim_" + this.world.field_73011_w.getDimension() + ".dat").exists()) {
                NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "BlockDataDim_" + this.world.field_73011_w.getDimension() + ".dat"));
                for (String keyName : data.func_150296_c()) {
                    NBTTagCompound nbt = data.func_74775_l(keyName);
                    BlockDataPoint bdp = this.getBlockDataFromNBT(nbt.func_74762_e("xCoord"), nbt.func_74762_e("yCoord"), nbt.func_74762_e("zCoord"), nbt);
                    if (bdp == null) continue;
                    bdp.readFromNBT(nbt);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToFile(boolean unloadInstances) {
        try {
            NBTTagCompound data = new NBTTagCompound();
            Collection<BlockDataPoint> playerDataCl = this.grid.values();
            for (BlockDataPoint bdp : playerDataCl) {
                data.func_74782_a("" + bdp.hash, (NBTBase)bdp.writeToNBT());
            }
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator;
            if (!new File(saveFolder).exists()) {
                new File(saveFolder).mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(saveFolder + "BlockDataDim_" + this.world.field_73011_w.getDimension() + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void tick() {
    }
}

