/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.shader;

import java.io.InputStream;
import java.util.Scanner;
import javax.vecmath.Matrix4f;

public class Utils {
    public static String loadResource(String fileName) throws Exception {
        String result;
        try (InputStream in = Utils.class.getClass().getResourceAsStream(fileName);
             Scanner scanner = new Scanner(in, "UTF-8");){
            result = scanner.useDelimiter("\\A").next();
        }
        return result;
    }

    public static Matrix4f setPerspective(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne) {
        boolean nearInf;
        Matrix4f mat = new Matrix4f();
        float h = (float)Math.tan(fovy * 0.5f);
        mat.m00 = 1.0f / (h * aspect);
        mat.m11 = 1.0f / h;
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            float e = 1.0E-6f;
            mat.m22 = e - 1.0f;
            mat.m32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            float e = 1.0E-6f;
            mat.m22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            mat.m32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            mat.m22 = (zZeroToOne ? zFar : zFar + zNear) / (zNear - zFar);
            mat.m32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        mat.m23 = -1.0f;
        return mat;
    }

    public static Matrix4f perspective(float fovy, float aspect, float near, float far) {
        Matrix4f perspective = new Matrix4f();
        float f = (float)(1.0 / Math.tan(Math.toRadians(fovy) / 2.0));
        perspective.m00 = f / aspect;
        perspective.m11 = f;
        perspective.m22 = (far + near) / (near - far);
        perspective.m32 = -1.0f;
        perspective.m23 = 2.0f * far * near / (near - far);
        perspective.m33 = 0.0f;
        return perspective;
    }
}

