/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.context;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.world.chunk.Chunk;

public final class Region {
    private static final int DISTANCE_THRESHOLD = 2;
    private final Set<Chunk> chunks = new ObjectOpenHashSet();
    private int totalEntities = -1;

    public static List<Region> mapChunks(List<Chunk> chunks) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Chunk chunk : chunks) {
            for (ClassInheritanceMultiMap map : chunk.func_177429_s()) {
                if (map.isEmpty()) continue;
                boolean found = false;
                for (Region region : regions) {
                    if (!region.isAdjacent(chunk)) continue;
                    found = true;
                    region.add(chunk);
                    Iterator iterator = regions.iterator();
                    while (iterator.hasNext()) {
                        Region otherRegion = (Region)iterator.next();
                        if (region == otherRegion || !otherRegion.isAdjacent(chunk)) continue;
                        iterator.remove();
                        region.merge(otherRegion);
                    }
                    break block2;
                }
                if (found) continue;
                regions.add(new Region(chunk));
            }
        }
        return regions;
    }

    private static long squaredEuclideanDistance(Chunk a, Chunk b) {
        long dx = a.field_76635_g - b.field_76635_g;
        long dz = a.field_76647_h - b.field_76647_h;
        return dx * dx + dz * dz;
    }

    private Region(Chunk chunk) {
        this.chunks.add(chunk);
    }

    public Collection<Chunk> chunks() {
        return Collections.unmodifiableCollection(this.chunks);
    }

    public boolean isAdjacent(Chunk other) {
        for (Chunk chunk : this.chunks) {
            if (Region.squaredEuclideanDistance(chunk, other) > 2L) continue;
            return true;
        }
        return false;
    }

    public int totalEntities() {
        if (this.totalEntities == -1) {
            this.totalEntities = 0;
            for (Chunk chunk : this.chunks) {
                for (ClassInheritanceMultiMap map : chunk.func_177429_s()) {
                    this.totalEntities += map.size();
                }
            }
        }
        return this.totalEntities;
    }

    private void add(Chunk chunk) {
        this.chunks.add(chunk);
    }

    private void merge(Region region) {
        this.chunks.addAll(region.chunks);
    }
}

