/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.node.type;

import com.cleanroommc.flare.api.sampler.node.description.NodeDescription;
import com.cleanroommc.flare.common.sampler.window.ProtoTimeEncoder;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntPredicate;

public abstract class SamplingStackNode {
    public static final int NULL_LINE_NUMBER = -1;
    protected final ConcurrentMap<NodeDescription, SamplingStackNode> children = new ConcurrentHashMap<NodeDescription, SamplingStackNode>();
    protected final ConcurrentMap<Integer, LongAdder> times = new ConcurrentHashMap<Integer, LongAdder>();

    public static int maxStackDepth(int defaultValue) {
        return Integer.getInteger("flare.maxStackDepth", defaultValue);
    }

    public static int maxStackDepth() {
        return SamplingStackNode.maxStackDepth(300);
    }

    protected abstract SamplingStackNode resolveChild(NodeDescription var1);

    protected LongAdder timeAccumulator(int window) {
        LongAdder adder = (LongAdder)this.times.get(window);
        if (adder == null) {
            adder = new LongAdder();
            this.times.put(window, adder);
        }
        return adder;
    }

    public Set<Integer> timeWindows() {
        return this.times.keySet();
    }

    public boolean removeTimeWindows(IntPredicate predicate) {
        return this.times.keySet().removeIf(predicate::test);
    }

    public Collection<SamplingStackNode> children() {
        return this.children.values();
    }

    public double[] encodeTimesForProto(ProtoTimeEncoder encoder) {
        return encoder.encode(this.times);
    }

    protected void merge(SamplingStackNode other) {
        other.times.forEach((k, v) -> this.timeAccumulator((int)k).add(v.longValue()));
        other.children.forEach((k, v) -> this.resolveChild((NodeDescription)k).merge((SamplingStackNode)v));
    }
}

