/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.node.type;

import com.cleanroommc.flare.api.sampler.node.MergeMode;
import com.cleanroommc.flare.api.sampler.node.MethodDescriptorResolver;
import com.cleanroommc.flare.api.sampler.node.description.NodeDescription;
import com.cleanroommc.flare.api.sampler.node.type.SamplingStackNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackTraceNode
extends SamplingStackNode {
    private final NodeDescription description;

    public StackTraceNode(NodeDescription description) {
        this.description = description;
    }

    @Override
    protected SamplingStackNode resolveChild(NodeDescription description) {
        return this.children.computeIfAbsent(description, StackTraceNode::new);
    }

    public String className() {
        return this.description.className();
    }

    public String methodName() {
        return this.description.methodName();
    }

    public String methodDescription() {
        return this.description.methodDescription();
    }

    public int lineNumber() {
        return this.description.lineNumber();
    }

    public int parentLineNumber() {
        return this.description.parentLineNumber();
    }

    public List<StackTraceNode> exportChildren(MethodDescriptorResolver resolver, boolean separateParentCalls) {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(this.children.size());
        block0: for (SamplingStackNode child : this.children.values()) {
            if (!(child instanceof StackTraceNode)) continue;
            StackTraceNode stackTraceChildNode = (StackTraceNode)child;
            for (StackTraceNode other : list) {
                if (!MergeMode.shouldMerge(resolver, separateParentCalls, other, stackTraceChildNode)) continue;
                other.merge(child);
                continue block0;
            }
            list.add(stackTraceChildNode);
        }
        return list;
    }
}

