/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.api.sampler.source;

import com.cleanroommc.flare.api.sampler.node.type.SamplingStackNode;
import com.cleanroommc.flare.api.sampler.node.type.StackTraceNode;
import com.cleanroommc.flare.api.sampler.node.type.ThreadNode;
import com.cleanroommc.flare.api.util.ClassFinder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface ClassSourceLookup {
    public static final ClassSourceLookup NO_OP = new ClassSourceLookup(){

        @Override
        @Nullable
        public String identify(String className) {
            return null;
        }
    };

    @Nullable
    public String identify(String var1) throws Exception;

    @Nullable
    default public String identify(MethodCall methodCall) throws Exception {
        return null;
    }

    @Nullable
    default public String identify(MethodCallByLine methodCall) throws Exception {
        return null;
    }

    public static Visitor createVisitor(ClassSourceLookup lookup) {
        if (lookup == NO_OP) {
            return NoOpVisitor.INSTANCE;
        }
        return new VisitorImpl(lookup);
    }

    public static final class MethodCallByLine {
        private final String className;
        private final String methodName;
        private final int lineNumber;

        public MethodCallByLine(String className, String methodName, int lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String toString() {
            return this.className + ";" + this.lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCallByLine)) {
                return false;
            }
            MethodCallByLine that = (MethodCallByLine)o;
            return this.lineNumber == that.lineNumber && this.className.equals(that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.lineNumber);
        }
    }

    public static final class MethodCall {
        private final String className;
        private final String methodName;
        private final String methodDescriptor;

        public MethodCall(String className, String methodName, String methodDescriptor) {
            this.className = className;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDescriptor() {
            return this.methodDescriptor;
        }

        public String toString() {
            return this.className + ";" + this.methodName + ";" + this.methodDescriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCall)) {
                return false;
            }
            MethodCall that = (MethodCall)o;
            return this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.methodDescriptor.equals(that.methodDescriptor);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.methodName, this.methodDescriptor);
        }
    }

    public static final class SourcesMap<T> {
        private final Map<T, String> map = new Object2ObjectOpenHashMap();
        private final Function<? super T, String> keyToStringFunction;

        private SourcesMap(Function<? super T, String> keyToStringFunction) {
            this.keyToStringFunction = keyToStringFunction;
        }

        public void computeIfAbsent(T key, ComputeSourceFunction<T> function) {
            if (!this.map.containsKey(key)) {
                try {
                    this.map.put(key, function.compute(key));
                }
                catch (Throwable e) {
                    this.map.put(key, null);
                }
            }
        }

        public boolean hasMappings() {
            this.map.values().removeIf(Objects::isNull);
            return !this.map.isEmpty();
        }

        public Map<String, String> export() {
            this.map.values().removeIf(Objects::isNull);
            if (this.keyToStringFunction.equals(Function.identity())) {
                return this.map;
            }
            return this.map.entrySet().stream().collect(Collectors.toMap(e -> this.keyToStringFunction.apply(e.getKey()), Map.Entry::getValue));
        }

        private static interface ComputeSourceFunction<T> {
            public String compute(T var1) throws Exception;
        }
    }

    public static class VisitorImpl
    implements Visitor {
        private final ClassSourceLookup lookup;
        private final SourcesMap<String> classSources = new SourcesMap(Function.identity());
        private final SourcesMap<MethodCall> methodSources = new SourcesMap(MethodCall::toString);
        private final SourcesMap<MethodCallByLine> lineSources = new SourcesMap(MethodCallByLine::toString);

        VisitorImpl(ClassSourceLookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void visit(ThreadNode node) {
            ArrayDeque<SamplingStackNode> queue = new ArrayDeque<SamplingStackNode>(node.children());
            SamplingStackNode n = (SamplingStackNode)queue.poll();
            while (n != null) {
                if (n instanceof StackTraceNode) {
                    this.visitStackNode((StackTraceNode)n);
                    queue.addAll(n.children());
                }
                n = (SamplingStackNode)queue.poll();
            }
        }

        private void visitStackNode(StackTraceNode node) {
            this.classSources.computeIfAbsent(node.className(), this.lookup::identify);
            if (node.methodDescription() != null) {
                MethodCall methodCall = new MethodCall(node.className(), node.methodName(), node.methodDescription());
                this.methodSources.computeIfAbsent(methodCall, this.lookup::identify);
            } else {
                MethodCallByLine methodCall = new MethodCallByLine(node.className(), node.methodName(), node.lineNumber());
                this.lineSources.computeIfAbsent(methodCall, this.lookup::identify);
            }
        }

        @Override
        public boolean hasClassSourceMappings() {
            return this.classSources.hasMappings();
        }

        @Override
        public Map<String, String> getClassSourceMapping() {
            return this.classSources.export();
        }

        @Override
        public boolean hasMethodSourceMappings() {
            return this.methodSources.hasMappings();
        }

        @Override
        public Map<String, String> getMethodSourceMapping() {
            return this.methodSources.export();
        }

        @Override
        public boolean hasLineSourceMappings() {
            return this.lineSources.hasMappings();
        }

        @Override
        public Map<String, String> getLineSourceMapping() {
            return this.lineSources.export();
        }
    }

    public static final class NoOpVisitor
    implements Visitor {
        public static final NoOpVisitor INSTANCE = new NoOpVisitor();

        private NoOpVisitor() {
        }

        @Override
        public void visit(ThreadNode node) {
        }

        @Override
        public boolean hasClassSourceMappings() {
            return false;
        }

        @Override
        public Map<String, String> getClassSourceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public boolean hasMethodSourceMappings() {
            return false;
        }

        @Override
        public Map<String, String> getMethodSourceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public boolean hasLineSourceMappings() {
            return false;
        }

        @Override
        public Map<String, String> getLineSourceMapping() {
            return Collections.emptyMap();
        }
    }

    public static interface Visitor {
        public void visit(ThreadNode var1);

        public boolean hasClassSourceMappings();

        public Map<String, String> getClassSourceMapping();

        public boolean hasMethodSourceMappings();

        public Map<String, String> getMethodSourceMapping();

        public boolean hasLineSourceMappings();

        public Map<String, String> getLineSourceMapping();
    }

    public static class ByCodeSource
    implements ClassSourceLookup,
    ByUrl {
        @Override
        @Nullable
        public String identify(String className) throws URISyntaxException, MalformedURLException {
            Class<?> clazz = ClassFinder.findClass(className);
            if (clazz == null) {
                return null;
            }
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL url = codeSource.getLocation();
            return url == null ? null : this.identifyUrl(url);
        }
    }

    public static class ByFirstUrlSource
    extends ByClassLoader
    implements ByUrl {
        @Override
        @Nullable
        public String identify(ClassLoader loader) throws IOException, URISyntaxException {
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                URL[] urls = urlClassLoader.getURLs();
                if (urls.length == 0) {
                    return null;
                }
                return this.identifyUrl(urls[0]);
            }
            return null;
        }
    }

    public static interface ByUrl
    extends ClassSourceLookup {
        default public String identifyUrl(URL url) throws URISyntaxException, MalformedURLException {
            Path path = null;
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                path = Paths.get(url.toURI());
            } else if (protocol.equals("jar")) {
                URL innerUrl = new URL(url.getPath());
                path = Paths.get(innerUrl.getPath().split("!")[0], new String[0]);
            }
            if (path != null) {
                return this.identifyFile(path.toAbsolutePath().normalize());
            }
            return null;
        }

        default public String identifyFile(Path path) {
            return this.identifyFileName(path.getFileName().toString());
        }

        default public String identifyFileName(String fileName) {
            return fileName.endsWith(".jar") ? fileName.substring(0, fileName.length() - 4) : null;
        }
    }

    public static abstract class ByClassLoader
    implements ClassSourceLookup {
        @Nullable
        public abstract String identify(ClassLoader var1) throws Exception;

        @Override
        @Nullable
        public final String identify(String className) throws Exception {
            Class<?> clazz = ClassFinder.findClass(className);
            if (clazz == null) {
                return null;
            }
            for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
                String source = this.identify(loader);
                if (source == null) continue;
                return source;
            }
            return null;
        }
    }
}

