/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.component.ping;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.ping.PingStatistics;
import com.cleanroommc.flare.api.ping.PingSummary;
import com.cleanroommc.flare.api.ping.PlayerPing;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.util.LangKeys;
import com.cleanroommc.flare.util.RollingAverage;
import com.cleanroommc.flare.util.StatisticFormatter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public class PingCommand
extends FlareSubCommand {
    public PingCommand(FlareAPI flare) {
        super(flare);
    }

    public String func_71517_b() {
        return "ping";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare ping (player name) OR (player uuid)";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Arrays.asList(server.func_184103_al().func_72369_d());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (FMLLaunchHandler.side().isClient() && server instanceof IntegratedServer && !((IntegratedServer)server).func_71344_c()) {
            this.sendMessage(sender, LangKeys.PING_STATISTICS_SINGLEPLAYER, new Object[0]);
        } else {
            PingStatistics stats = this.flare.pingStats();
            if (args.length > 0) {
                String flag = args[0];
                if (!flag.equalsIgnoreCase("player")) {
                    this.sendMessage(sender, LangKeys.MALFORMED_FLAGS, "player");
                    return;
                }
                if (args.length == 1) {
                    this.sendMessage(sender, LangKeys.NO_INPUTS, "player");
                    return;
                }
                for (int i = 1; i < args.length; ++i) {
                    String input = args[i];
                    EntityPlayerMP player = PingCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)input);
                    PlayerPing ping = stats.playerPing((EntityPlayer)player);
                    this.sendMessage(sender, LangKeys.PING_STATISTICS_SPECIFIC_PLAYER, ping.name(), ping.ping());
                }
            } else {
                PingSummary summary = stats.currentSummary();
                RollingAverage average = (RollingAverage)stats.average();
                if (summary.total() == 0 && average.getSamples() == 0) {
                    this.sendMessage(sender, LangKeys.PING_STATISTICS_NOT_ENOUGH_DATA, new Object[0]);
                    return;
                }
                this.sendMessage(sender, LangKeys.PING_STATISTICS_AVERAGES, StatisticFormatter.formatPingRtts(average.min(), average.median(), average.percentile95th(), average.max()), StatisticFormatter.formatPingRtts(summary.min(), summary.median(), summary.percentile95th(), summary.max()));
            }
        }
    }
}

