/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.component.tick;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.tick.TickStatistics;
import com.cleanroommc.flare.api.tick.TickType;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.component.cpu.CpuMonitor;
import com.cleanroommc.flare.util.LangKeys;
import com.cleanroommc.flare.util.StatisticFormatter;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.relauncher.Side;

public class TPSCommand
extends FlareSubCommand {
    private final Side side;

    public TPSCommand(Side side, FlareAPI flare) {
        super(flare);
        this.side = side;
    }

    public String func_71517_b() {
        return "tps";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("cpu");
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare tps [--type [all / render / world / player]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        TickType tickType;
        String type = this.getArgValue(args, "type");
        if (type == null) {
            type = "all";
        }
        switch (type) {
            case "render": {
                tickType = TickType.RENDER;
                break;
            }
            case "world": {
                tickType = TickType.WORLD;
                break;
            }
            case "player": {
                tickType = TickType.PLAYER;
                break;
            }
            default: {
                tickType = TickType.ALL;
            }
        }
        if (this.side.isServer() && tickType == TickType.RENDER) {
            this.sendMessage(sender, LangKeys.TPS_SERVER_HAS_NO_RENDERING, new Object[0]);
            return;
        }
        TickStatistics stats = this.flare.tickStatistics(this.side, tickType);
        this.sendMessage(sender, LangKeys.TPS_STATISTICS_RECALL, StatisticFormatter.formatTps(stats.tps5Sec()), StatisticFormatter.formatTps(stats.tps10Sec()), StatisticFormatter.formatTps(stats.tps1Min()), StatisticFormatter.formatTps(stats.tps5Min()), StatisticFormatter.formatTps(stats.tps15Min()));
        if (stats.isDurationSupported()) {
            this.sendMessage(sender, LangKeys.TPS_STATISTICS_DURATION_AVERAGES, StatisticFormatter.formatTickDurations(stats.duration10Sec()), StatisticFormatter.formatTickDurations(stats.duration1Min()));
        }
        this.sendMessage(sender, LangKeys.CPU_USAGE_SYSTEM_LOAD, StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad10SecAvg()), StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad1MinAvg()), StatisticFormatter.formatCpuUsage(CpuMonitor.systemLoad15MinAvg()));
        this.sendMessage(sender, LangKeys.CPU_USAGE_PROCESS_LOAD, StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad10SecAvg()), StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad1MinAvg()), StatisticFormatter.formatCpuUsage(CpuMonitor.processLoad15MinAvg()));
    }
}

