/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.component.tick;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.api.tick.TickType;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.component.tick.ReportPredicate;
import com.cleanroommc.flare.common.component.tick.TickMonitor;
import com.cleanroommc.flare.util.LangKeys;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.relauncher.Side;

public class TickMonitoringCommand
extends FlareSubCommand {
    private final Side side;
    private TickMonitor activeTickMonitor = null;

    public TickMonitoringCommand(Side side, FlareAPI flare) {
        super(flare);
        this.side = side;
    }

    public String func_71517_b() {
        return "tickmonitor";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("tickmonitoring", "tm");
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare tickmonitor [--threshold (integer) / --threshold-tick (integer)], [--without-gc]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (this.activeTickMonitor != null) {
            this.activeTickMonitor.stop();
            this.activeTickMonitor = null;
            this.sendMessage(sender, LangKeys.TICK_MONITORING_DISABLED, new Object[0]);
            return;
        }
        TickRoutine tickRoutine = this.flare.tickRoutine(this.side);
        ReportPredicate reportPredicate = null;
        String thresholdArg = this.getArgValue(args, "threshold");
        if (thresholdArg != null) {
            try {
                reportPredicate = new ReportPredicate.PercentageChangeGt(Integer.parseInt(thresholdArg));
            }
            catch (NumberFormatException e) {
                this.sendMessage(sender, LangKeys.MALFORMED_INPUTS, "threshold");
            }
        } else {
            String thresholdTickArg = this.getArgValue(args, "threshold-tick");
            if (thresholdTickArg != null) {
                try {
                    reportPredicate = new ReportPredicate.DurationGt(Integer.parseInt(thresholdTickArg));
                }
                catch (NumberFormatException e) {
                    this.sendMessage(sender, LangKeys.MALFORMED_INPUTS, "threshold-tick");
                }
            }
        }
        if (reportPredicate == null) {
            reportPredicate = new ReportPredicate.PercentageChangeGt(100.0);
        }
        this.activeTickMonitor = new TickMonitor(this.flare, this.side, TickType.ALL, tickRoutine, reportPredicate, this.hasArg(args, "without-gc"));
        this.activeTickMonitor.start(sender);
    }
}

