/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.memory.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.component.memory.heap.dump.HeapDump;
import com.cleanroommc.flare.util.FormatUtil;
import com.cleanroommc.flare.util.LangKeys;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;

public class HeapDumpCommand
extends FlareSubCommand {
    public HeapDumpCommand(FlareAPI flare) {
        super(flare);
    }

    public String func_71517_b() {
        return "dump";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("d");
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare heap dump [--run-gc-first], [--include-non-live], [--compress]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Path heapDumpDir = this.flare.saveDirectory().resolve("heap").resolve("dump");
        String fileName = new SimpleDateFormat("yyyy-MM-dd-hh_mm_ss").format(new Date()) + (HeapDump.isOpenJ9() ? ".phd" : ".hprof");
        Path heapDumpFile = heapDumpDir.resolve(fileName);
        this.sendMessage(sender, LangKeys.HEAP_DUMP_WAIT, new Object[0]);
        try {
            Files.createDirectories(heapDumpDir, new FileAttribute[0]);
            if (this.hasArg(args, "run-gc-first")) {
                System.gc();
            }
            HeapDump.dumpHeap(heapDumpFile, !this.hasArg(args, "include-non-live"));
            this.sendMessage(sender, LangKeys.HEAP_DUMP_REPORT, (TextComponentTranslation text) -> text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, heapDumpFile.toFile().getAbsolutePath())), heapDumpFile.getFileName());
        }
        catch (Exception e) {
            this.sendMessage(sender, LangKeys.INSPECTING_HEAP_UNEXPECTED_EXCEPTION, new Object[0]);
            e.printStackTrace();
            return;
        }
        if (this.hasArg(args, "compress")) {
            this.sendMessage(sender, LangKeys.COMPRESS_FILE_START, "heap dump");
            try {
                long size = Files.size(heapDumpFile);
                AtomicLong lastReport = new AtomicLong(System.currentTimeMillis());
                this.flare.runAsync(() -> {
                    Path heapDumpCompressedFile = heapDumpDir.resolve(fileName + ".gz");
                    try (InputStream is = Files.newInputStream(heapDumpFile, new OpenOption[0]);){
                        try (GZIPOutputStream os = new GZIPOutputStream(Files.newOutputStream(heapDumpCompressedFile, new OpenOption[0]), 65536);){
                            int r;
                            byte[] buf = new byte[65536];
                            AtomicLong total = new AtomicLong();
                            long iterations = 0L;
                            while ((r = is.read(buf)) != -1) {
                                long millis;
                                long timeSinceLastReport;
                                os.write(buf, 0, r);
                                total.addAndGet(r);
                                if (iterations++ % 80L != 0L || (timeSinceLastReport = (millis = System.currentTimeMillis()) - lastReport.get()) <= TimeUnit.SECONDS.toMillis(5L)) continue;
                                lastReport.set(millis);
                                this.flare.syncWithServer(() -> this.sendMessage(sender, LangKeys.COMPRESS_FILE_PROGRESS, FormatUtil.formatBytes(total.get()), FormatUtil.formatBytes(size), FormatUtil.percent(total.get(), size)));
                            }
                        }
                        long heapDumpCompressedSize = Files.size(heapDumpCompressedFile);
                        this.flare.syncWithServer(() -> this.sendMessage(sender, LangKeys.COMPRESS_FILE_REPORT, (TextComponentTranslation text) -> text.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, heapDumpCompressedFile.toAbsolutePath().toString())), FormatUtil.formatBytes(size), FormatUtil.formatBytes(heapDumpCompressedSize), FormatUtil.percent(heapDumpCompressedSize, size), heapDumpCompressedFile.getFileName()));
                    }
                    catch (IOException e) {
                        this.sendMessage(sender, LangKeys.CANNOT_COMPRESS_FILE, new Object[0]);
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                this.sendMessage(sender, LangKeys.CANNOT_COMPRESS_FILE, new Object[0]);
                e.printStackTrace();
            }
        }
    }
}

