/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.sampler.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.FlareClientAPI;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.api.sampler.SamplerBuilder;
import com.cleanroommc.flare.api.sampler.SamplerContainer;
import com.cleanroommc.flare.api.sampler.SamplerMode;
import com.cleanroommc.flare.api.sampler.thread.ThreadDumper;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.util.LangKeys;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.relauncher.Side;

public class SamplerStartCommand
extends FlareSubCommand {
    private final Side side;

    public SamplerStartCommand(Side side, FlareAPI flare) {
        super(flare);
        this.side = side;
    }

    public String func_71517_b() {
        return "start";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare sampler start [--arguments]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SamplerContainer<Sampler> samplerContainer = this.flare.samplerContainer();
        Sampler sampler = samplerContainer.activeSampler();
        if (sampler != null) {
            this.sendMessage(sender, LangKeys.SAMPLER_ALREADY_STARTED, new Object[0]);
        } else {
            Set<String> regex;
            Set<String> threads;
            this.setExportProps(samplerContainer.getExportProps(), sender, args);
            int timeoutSeconds = this.getIntArgValue(args, "timeout");
            if (timeoutSeconds != -1) {
                if (timeoutSeconds <= 10) {
                    this.sendMessage(sender, LangKeys.SAMPLER_START_TIMEOUT_TOO_SHORT, new Object[0]);
                    return;
                }
                if (timeoutSeconds < 30) {
                    this.sendMessage(sender, LangKeys.SAMPLER_START_TIMEOUT_SHORT, new Object[0]);
                }
            }
            SamplerMode mode = this.hasArg(args, "alloc") ? SamplerMode.ALLOCATION : SamplerMode.EXECUTION;
            boolean allocLiveOnly = this.hasArg(args, "alloc-live-only");
            int interval = this.getIntArgValue(args, "interval");
            if (interval <= mode.interval()) {
                interval = mode.interval();
            }
            ThreadDumper threadDumper = (threads = this.getArgValues(args, "thread")).isEmpty() ? (this.side.isClient() ? ((FlareClientAPI)((Object)this.flare)).clientThreadDumper() : this.flare.serverThreadDumper()) : (threads.contains("*") ? ThreadDumper.ALL : (!(regex = this.getArgValues(args, "regex")).isEmpty() ? new ThreadDumper.Regex(regex) : new ThreadDumper.Specific(threads)));
            ThreadGrouper threadGrouper = ThreadGrouper.BY_POOL;
            String threadGrouperValue = this.getArgValue(args, "thread-grouper");
            if (threadGrouperValue != null) {
                switch (threadGrouperValue) {
                    case "combine-all": {
                        threadGrouper = ThreadGrouper.AS_ONE;
                        break;
                    }
                    case "not-combined": {
                        threadGrouper = ThreadGrouper.BY_NAME;
                    }
                }
            }
            boolean ignoreSleeping = this.hasArg(args, "ignore-sleeping");
            boolean ignoreNative = this.hasArg(args, "ignore-native");
            boolean forceJavaSampler = this.hasArg(args, "force-java-sampler");
            SamplerBuilder samplerBuilder = this.flare.samplerBuilder().mode(mode).interval(interval).allocLiveOnly(allocLiveOnly).threadDumper(threadDumper).threadGrouper(threadGrouper).ignoreSleeping(ignoreSleeping).ignoreNative(ignoreNative).forceJavaSampler(forceJavaSampler);
            if (timeoutSeconds != -1) {
                samplerBuilder.completeAfter(timeoutSeconds, TimeUnit.SECONDS);
            }
            sampler = samplerBuilder.build();
            samplerContainer.setSampler(sampler);
            this.sendMessage(sender, LangKeys.SAMPLER_START, new Object[0]);
            sampler.start();
        }
    }

    private void setExportProps(ExportProps exportProps, ICommandSender sender, String[] args) {
        exportProps.creator(sender).separateParentCalls(this.hasArg(args, "separate-parent-calls")).saveToFile(this.hasArg(args, "save-to-file"));
        ExportProps.setDefault(this.flare, exportProps);
        String comment = this.getArgValue(args, "comment");
        if (comment != null) {
            exportProps.comment(comment);
        }
    }
}

