/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.command.sub.sampler.sub;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.Sampler;
import com.cleanroommc.flare.api.sampler.SamplerContainer;
import com.cleanroommc.flare.common.command.sub.FlareSubCommand;
import com.cleanroommc.flare.common.command.sub.sampler.sub.SamplerUtil;
import com.cleanroommc.flare.common.sampler.AbstractSampler;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.common.websocket.ViewerSocket;
import com.cleanroommc.flare.util.LangKeys;
import me.lucko.bytesocks.client.BytesocksClient;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;

public class SamplerViewCommand
extends FlareSubCommand {
    public SamplerViewCommand(FlareAPI flare) {
        super(flare);
    }

    public String func_71517_b() {
        return "view";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/flare sampler view";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SamplerContainer samplerContainer = this.flare.samplerContainer();
        Sampler sampler = samplerContainer.activeSampler();
        if (sampler == null) {
            this.sendMessage(sender, LangKeys.SAMPLER_HAS_NOT_STARTED, new Object[0]);
            return;
        }
        BytesocksClient bytesocksClient = this.flare.get(BytesocksClient.class);
        if (bytesocksClient == null) {
            this.sendMessage(sender, LangKeys.SAMPLER_VIEWER_UNSUPPORTED, new Object[0]);
            return;
        }
        this.flare.runAsync(() -> {
            try {
                ExportProps exportProps = samplerContainer.getExportProps();
                ExportProps.setDefault(this.flare, exportProps);
                ViewerSocket viewerSocket = new ViewerSocket(this.flare, bytesocksClient, exportProps);
                AbstractSampler abstractSampler = (AbstractSampler)sampler;
                abstractSampler.attachSocket(viewerSocket);
                exportProps.channelInfo(viewerSocket.getPayload());
                String url = SamplerUtil.upload(this.flare, exportProps, sampler, true, false);
                this.sendMessage(sender, LangKeys.SAMPLER_VIEWER_OPEN, (TextComponentTranslation msg) -> msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url)), url);
            }
            catch (Throwable t) {
                this.sendMessage(sender, LangKeys.SAMPLER_VIEWER_FAILED_UNEXPECTEDLY, t.toString());
                this.flare.logger().fatal((Object)t);
            }
        });
    }
}

