/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.memory.heap.dump;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.asm.Type;

public final class HeapDumpSummary {
    private static final String DIAGNOSTIC_BEAN = "com.sun.management:type=DiagnosticCommand";
    private static final Pattern OUTPUT_FORMAT = Pattern.compile("^\\s*(\\d+):\\s*(\\d+)\\s*(\\d+)\\s*([^\\s]+).*$");
    private final List<Entry> entries;

    private static String getRawHeapData() throws Exception {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName diagnosticBeanName = ObjectName.getInstance(DIAGNOSTIC_BEAN);
        DiagnosticCommandMXBean proxy = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, DiagnosticCommandMXBean.class);
        return proxy.gcClassHistogram(new String[0]);
    }

    private static String typeToClassName(String type) {
        try {
            Type typed = Type.getType((String)type);
            if (typed.getSort() == 11) {
                typed = Type.getType((String)("L" + type + ";"));
            }
            return typed.getClassName();
        }
        catch (IllegalArgumentException e) {
            return type;
        }
    }

    public static HeapDumpSummary createNew() {
        String rawOutput;
        try {
            rawOutput = HeapDumpSummary.getRawHeapData();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get heap dump!", e);
        }
        return new HeapDumpSummary(Arrays.stream(rawOutput.split("\n")).map(line -> {
            Matcher matcher = OUTPUT_FORMAT.matcher((CharSequence)line);
            if (!matcher.matches()) {
                return null;
            }
            try {
                return new Entry(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Long.parseLong(matcher.group(3)), HeapDumpSummary.typeToClassName(matcher.group(4)));
            }
            catch (Exception e) {
                new IllegalArgumentException("Exception parsing line: " + line, e).printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private HeapDumpSummary(List<Entry> entries) {
        this.entries = entries;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public static interface DiagnosticCommandMXBean {
        public String gcClassHistogram(String[] var1);
    }

    public static final class Entry {
        private final int order;
        private final int instances;
        private final long bytes;
        private final String type;

        Entry(int order, int instances, long bytes, String type) {
            this.order = order;
            this.instances = instances;
            this.bytes = bytes;
            this.type = type;
        }

        public int order() {
            return this.order;
        }

        public int instances() {
            return this.instances;
        }

        public long bytes() {
            return this.bytes;
        }

        public String type() {
            return this.type;
        }
    }
}

