/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.network;

import com.cleanroommc.flare.common.component.network.NetworkInterfaceAverages;
import com.cleanroommc.flare.common.component.network.NetworkInterfaceInfo;
import com.cleanroommc.flare.util.MonitoringExecutor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class NetworkMonitor {
    private static final AtomicReference<Map<String, NetworkInterfaceInfo>> SYSTEM = new AtomicReference();
    private static final Pattern INTERFACES_TO_IGNORE = Pattern.compile("^(veth\\w+)|(br-\\w+)$");
    private static final Map<String, NetworkInterfaceAverages> SYSTEM_AVERAGES = new ConcurrentHashMap<String, NetworkInterfaceAverages>();
    private static final int POLL_INTERVAL = 60;
    private static final int WINDOW_SIZE_SECONDS = (int)TimeUnit.MINUTES.toSeconds(15L);
    private static final int WINDOW_SIZE = WINDOW_SIZE_SECONDS / 60;

    public static void ensureMonitoring() {
    }

    public static Map<String, NetworkInterfaceInfo> systemTotals() {
        Map<String, NetworkInterfaceInfo> values = SYSTEM.get();
        return values == null ? Collections.emptyMap() : values;
    }

    public static Map<String, NetworkInterfaceAverages> systemAverages() {
        return Collections.unmodifiableMap(SYSTEM_AVERAGES);
    }

    private NetworkMonitor() {
    }

    static {
        MonitoringExecutor.INSTANCE.scheduleAtFixedRate(new RollingAverageCollectionTask(), 1L, 60L, TimeUnit.SECONDS);
    }

    private static final class RollingAverageCollectionTask
    implements Runnable {
        private static final BigDecimal POLL_INTERVAL_DECIMAL = BigDecimal.valueOf(60L);

        private RollingAverageCollectionTask() {
        }

        @Override
        public void run() {
            Map<String, NetworkInterfaceInfo> values = RollingAverageCollectionTask.pollAndDiff(NetworkInterfaceInfo::pollSystem, SYSTEM);
            if (values != null) {
                RollingAverageCollectionTask.submit(SYSTEM_AVERAGES, values);
            }
        }

        private static void submit(Map<String, NetworkInterfaceAverages> rollingAveragesMap, Map<String, NetworkInterfaceInfo> values) {
            for (String string : values.keySet()) {
                if (INTERFACES_TO_IGNORE.matcher(string).matches()) continue;
                rollingAveragesMap.computeIfAbsent(string, k -> new NetworkInterfaceAverages(WINDOW_SIZE));
            }
            for (Map.Entry entry : rollingAveragesMap.entrySet()) {
                String interfaceName = (String)entry.getKey();
                NetworkInterfaceAverages rollingAvgs = (NetworkInterfaceAverages)entry.getValue();
                NetworkInterfaceInfo info = values.getOrDefault(interfaceName, NetworkInterfaceInfo.ZERO);
                rollingAvgs.accept(info, RollingAverageCollectionTask::calculateRate);
            }
        }

        private static BigDecimal calculateRate(long value) {
            return BigDecimal.valueOf(value).divide(POLL_INTERVAL_DECIMAL, RoundingMode.HALF_UP);
        }

        private static Map<String, NetworkInterfaceInfo> pollAndDiff(Supplier<Map<String, NetworkInterfaceInfo>> poller, AtomicReference<Map<String, NetworkInterfaceInfo>> valueReference) {
            Map<String, NetworkInterfaceInfo> latest = poller.get();
            Map<String, NetworkInterfaceInfo> previous = valueReference.getAndUpdate(prev -> {
                if (prev == null && latest.isEmpty()) {
                    return null;
                }
                return latest;
            });
            if (previous == null) {
                return null;
            }
            return NetworkInterfaceInfo.difference(latest, previous);
        }
    }
}

