/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.tick;

import com.cleanroommc.flare.api.tick.TickCallback;
import com.cleanroommc.flare.api.tick.TickRoutine;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class FlareTickRoutine
implements TickRoutine {
    private final List<TickCallback> callbacks = new ArrayList<TickCallback>();
    private long start = 0L;
    private int tick = 0;

    protected void onTick(TickEvent.Phase phase) {
        double duration = (double)(System.nanoTime() - this.start) / 1000000.0;
        List<TickCallback> callbacks = this.callbacks;
        if (phase == TickEvent.Phase.START) {
            this.start = System.nanoTime();
            for (int i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).onTickStart(this.tick, duration);
            }
        } else {
            for (int i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).onTickEnd(this.tick, duration);
            }
            ++this.tick;
        }
    }

    @Override
    public void start() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void stop() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public int currentTick() {
        return this.tick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(TickCallback runnable) {
        List<TickCallback> list = this.callbacks;
        synchronized (list) {
            this.callbacks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallback(TickCallback runnable) {
        List<TickCallback> list = this.callbacks;
        synchronized (list) {
            this.callbacks.remove(runnable);
        }
    }

    public static class Server
    extends FlareTickRoutine {
        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            this.onTick(event.phase);
        }
    }

    public static class Client
    extends FlareTickRoutine {
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            this.onTick(event.phase);
        }
    }
}

