/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.component.tick;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.tick.TickCallback;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.api.tick.TickType;
import com.cleanroommc.flare.common.component.memory.heap.gc.GarbageCollectionMonitor;
import com.cleanroommc.flare.common.component.tick.ReportPredicate;
import com.cleanroommc.flare.util.ChatUtil;
import com.cleanroommc.flare.util.LangKeys;
import com.sun.management.GarbageCollectionNotificationInfo;
import java.util.DoubleSummaryStatistics;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.fml.relauncher.Side;

public class TickMonitor
implements TickCallback,
GarbageCollectionMonitor.Listener {
    private final FlareAPI flare;
    private final Side side;
    private final TickType type;
    private final TickRoutine tickRoutine;
    private final int zeroTick;
    private final GarbageCollectionMonitor garbageCollectionMonitor;
    private final ReportPredicate reportPredicate;
    private ICommandSender commandSender = null;
    private Phase phase = null;
    private volatile double lastTickTime = 0.0;
    private final DoubleSummaryStatistics averageTickTimeCalc = new DoubleSummaryStatistics();
    private double averageTickTime;

    public TickMonitor(FlareAPI flare, Side side, TickType type, TickRoutine tickRoutine, ReportPredicate reportPredicate, boolean monitorGc) {
        this.flare = flare;
        this.side = side;
        this.type = type;
        this.tickRoutine = tickRoutine;
        this.zeroTick = tickRoutine.currentTick();
        this.reportPredicate = reportPredicate;
        if (monitorGc) {
            this.garbageCollectionMonitor = new GarbageCollectionMonitor();
            this.garbageCollectionMonitor.addListener(this);
        } else {
            this.garbageCollectionMonitor = null;
        }
    }

    public int getCurrentTick() {
        return this.tickRoutine.currentTick() - this.zeroTick;
    }

    public void start(ICommandSender commandSender) {
        this.commandSender = commandSender;
        this.tickRoutine.addCallback(this);
    }

    public void stop() {
        this.tickRoutine.removeCallback(this);
        if (this.garbageCollectionMonitor != null) {
            this.garbageCollectionMonitor.close();
        }
        this.commandSender = null;
    }

    @Override
    public Side getSide() {
        return this.side;
    }

    @Override
    public void onTickStart(int currentTick, double duration) {
        double percentageChange;
        double increase;
        double now = (double)System.nanoTime() / 1000000.0;
        if (this.phase == null) {
            ChatUtil.sendMessage(this.flare, this.commandSender, LangKeys.TICK_MONITORING_START, new Object[0]);
            this.phase = Phase.SETUP;
            this.lastTickTime = now;
            return;
        }
        double last = this.lastTickTime;
        double tickDuration = now - last;
        this.lastTickTime = now;
        if (last == 0.0) {
            return;
        }
        if (this.phase == Phase.SETUP) {
            this.averageTickTimeCalc.accept(tickDuration);
            if (this.averageTickTimeCalc.getCount() >= 120L) {
                this.flare.syncWithServer(() -> {
                    ChatUtil.sendMessage(this.flare, this.commandSender, LangKeys.TICK_MONITORING_END, ChatUtil.FLOAT_FORMAT.format(this.averageTickTimeCalc.getMax()), ChatUtil.FLOAT_FORMAT.format(this.averageTickTimeCalc.getMin()), ChatUtil.FLOAT_FORMAT.format(this.averageTickTimeCalc.getAverage()));
                    ChatUtil.sendMessage(this.flare, this.commandSender, this.reportPredicate.getMonitoringStartMessage());
                });
                this.averageTickTime = this.averageTickTimeCalc.getAverage();
                this.phase = Phase.MONITORING;
            }
        }
        if (this.phase == Phase.MONITORING && this.reportPredicate.shouldReport(tickDuration, increase = tickDuration - this.averageTickTime, percentageChange = increase * 100.0 / this.averageTickTime)) {
            this.flare.syncWithServer(() -> ChatUtil.sendMessage(this.flare, this.commandSender, LangKeys.TICK_MONITORING_REPORT, this.getCurrentTick(), ChatUtil.FLOAT_FORMAT.format(tickDuration), ChatUtil.FLOAT_FORMAT.format(percentageChange)));
        }
    }

    @Override
    public void onGc(GarbageCollectionNotificationInfo data) {
        if (this.phase == Phase.SETUP) {
            this.lastTickTime = 0.0;
            return;
        }
        this.flare.syncWithServer(() -> ChatUtil.sendMessage(this.flare, this.commandSender, LangKeys.TICK_MONITORING_GC_REPORT, this.getCurrentTick(), ChatUtil.FLOAT_FORMAT.format(data.getGcInfo().getDuration()), GarbageCollectionMonitor.getGcType(data)));
    }

    private static enum Phase {
        SETUP,
        MONITORING;

    }
}

