/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.aggregator;

import com.cleanroommc.flare.api.sampler.node.type.ThreadNode;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.common.sampler.aggregator.DataAggregator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntPredicate;

public abstract class AbstractDataAggregator
implements DataAggregator {
    protected final ConcurrentMap<String, ThreadNode> threadData = new ConcurrentHashMap<String, ThreadNode>();
    protected final ThreadGrouper threadGrouper;

    protected AbstractDataAggregator(ThreadGrouper threadGrouper) {
        this.threadGrouper = threadGrouper;
    }

    protected ThreadNode getNode(String group) {
        return this.threadData.computeIfAbsent(group, ThreadNode::new);
    }

    @Override
    public void pruneData(IntPredicate timeWindowPredicate) {
        this.threadData.values().removeIf(node -> node.removeTimeWindowsRecursively(timeWindowPredicate));
    }

    @Override
    public List<ThreadNode> exportData() {
        ArrayList<ThreadNode> data = new ArrayList<ThreadNode>(this.threadData.values());
        for (ThreadNode node : data) {
            node.setLabel(this.threadGrouper.label(node.group()));
        }
        return data;
    }
}

