/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.async;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.sampler.SamplerMode;
import com.cleanroommc.flare.api.sampler.thread.ThreadDumper;
import com.cleanroommc.flare.api.sampler.thread.ThreadGrouper;
import com.cleanroommc.flare.api.sampler.window.ProfilingWindowUtils;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.common.sampler.AbstractSampler;
import com.cleanroommc.flare.common.sampler.ExportProps;
import com.cleanroommc.flare.common.sampler.async.AsyncDataAggregator;
import com.cleanroommc.flare.common.sampler.async.AsyncProfilerAccess;
import com.cleanroommc.flare.common.sampler.async.AsyncProfilerJob;
import com.cleanroommc.flare.common.sampler.async.SampleCollector;
import com.cleanroommc.flare.common.websocket.ViewerSocket;
import com.cleanroommc.flare.proto.FlareSamplerProtos;
import com.cleanroommc.flare.util.FlareThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import net.minecraftforge.fml.relauncher.Side;

public class AsyncSampler
extends AbstractSampler {
    private final SampleCollector<?> sampleCollector;
    private final AsyncProfilerAccess profilerAccess;
    private final AsyncDataAggregator dataAggregator;
    private final Object[] currentJobMutex = new Object[0];
    private AsyncProfilerJob currentJob;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> socketStatisticsTask;

    public AsyncSampler(FlareAPI flare, Side side, ThreadGrouper threadGrouper, SampleCollector<?> collector, int interval, ThreadDumper threadDumper, long endTime, boolean runningInBackground) {
        super(flare, side, interval, threadDumper, endTime, runningInBackground);
        this.sampleCollector = collector;
        this.profilerAccess = AsyncProfilerAccess.getInstance(flare);
        this.dataAggregator = new AsyncDataAggregator(threadGrouper);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new FlareThreadFactory(flare, "flare-async-sampler"));
    }

    @Override
    public SamplerMode mode() {
        return this.sampleCollector.mode();
    }

    @Override
    public void startWork() {
        boolean shouldNotRotate;
        TickRoutine tickHook = this.flare.tickRoutine(this.side);
        if (tickHook != null) {
            this.windowStatisticsCollector.startCountingTicks(tickHook);
        }
        int window = ProfilingWindowUtils.windowNow();
        AsyncProfilerJob job = this.profilerAccess.startNewProfilerJob();
        job.init(this.flare, this.sampleCollector, this.threadDumper, window, this.background);
        job.start();
        this.windowStatisticsCollector.recordWindowStartTime(window);
        this.currentJob = job;
        boolean bl = shouldNotRotate = this.sampleCollector instanceof SampleCollector.Allocation && ((SampleCollector.Allocation)this.sampleCollector).isLiveOnly();
        if (!shouldNotRotate) {
            this.scheduler.scheduleAtFixedRate(this::rotateProfilerJob, 10L, 10L, TimeUnit.SECONDS);
        }
        this.recordInitialGcStats();
        this.scheduleTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateProfilerJob() {
        try {
            Object[] objectArray = this.currentJobMutex;
            synchronized (this.currentJobMutex) {
                AsyncProfilerJob previousJob = this.currentJob;
                if (previousJob == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    previousJob.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int window = previousJob.getWindow() + 1;
                AsyncProfilerJob newJob = this.profilerAccess.startNewProfilerJob();
                newJob.init(this.flare, this.sampleCollector, this.threadDumper, window, this.background);
                newJob.start();
                this.windowStatisticsCollector.recordWindowStartTime(window);
                this.currentJob = newJob;
                try {
                    this.windowStatisticsCollector.measureNow(previousJob.getWindow());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                previousJob.aggregate(this.dataAggregator);
                IntPredicate predicate = ProfilingWindowUtils.keepHistoryBefore(window);
                this.dataAggregator.pruneData(predicate);
                this.windowStatisticsCollector.pruneStatistics(predicate);
                this.scheduler.execute(this::processWindowRotate);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        {
            return;
        }
    }

    private void scheduleTimeout() {
        if (this.autoEndTime == -1L) {
            return;
        }
        long delay = this.autoEndTime - System.currentTimeMillis();
        if (delay <= 0L) {
            return;
        }
        this.scheduler.schedule(() -> {
            try {
                this.stop(false);
                this.future.complete(this);
            }
            catch (Exception e) {
                this.future.completeExceptionally(e);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWork(boolean cancelled) {
        Object[] objectArray = this.currentJobMutex;
        synchronized (this.currentJobMutex) {
            this.currentJob.stop();
            if (!cancelled) {
                this.windowStatisticsCollector.measureNow(this.currentJob.getWindow());
                this.currentJob.aggregate(this.dataAggregator);
            } else {
                this.currentJob.deleteOutputFile();
            }
            this.currentJob = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.socketStatisticsTask != null) {
                this.socketStatisticsTask.cancel(false);
            }
            if (this.scheduler != null) {
                this.future.complete(this);
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            return;
        }
    }

    @Override
    public void attachSocket(ViewerSocket socket) {
        super.attachSocket(socket);
        if (this.socketStatisticsTask == null) {
            this.socketStatisticsTask = this.scheduler.scheduleAtFixedRate(this::sendStatisticsToSocket, 0L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public FlareSamplerProtos.SamplerData toProto(FlareAPI flare, ExportProps exportProps, boolean stop) {
        FlareSamplerProtos.SamplerData.Builder proto = FlareSamplerProtos.SamplerData.newBuilder();
        if (exportProps.channelInfo() != null) {
            proto.setChannelInfo(exportProps.channelInfo());
        }
        this.writeMetadataToProto(proto, exportProps, this.dataAggregator);
        this.writeDataToProto(proto, this.dataAggregator, exportProps);
        return (FlareSamplerProtos.SamplerData)proto.build();
    }
}

