/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.common.sampler.window;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.api.tick.TickRoutine;
import com.cleanroommc.flare.api.tick.TickStatistics;
import com.cleanroommc.flare.api.tick.TickType;
import com.cleanroommc.flare.api.util.DoubleAverageInfo;
import com.cleanroommc.flare.common.component.cpu.CpuMonitor;
import com.cleanroommc.flare.proto.FlareProtos;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import net.minecraftforge.fml.relauncher.Side;

public class WindowStatisticsCollector {
    private static final FlareProtos.WindowStatistics ZERO = (FlareProtos.WindowStatistics)FlareProtos.WindowStatistics.newBuilder().setDuration(10000).build();
    private final FlareAPI flare;
    private final Side side;
    private final Map<Integer, Long> windowStartTimes = new HashMap<Integer, Long>();
    private final Map<Integer, FlareProtos.WindowStatistics> stats;
    private TickCounter tickCounter;

    public WindowStatisticsCollector(FlareAPI flare, Side side) {
        this.flare = flare;
        this.side = side;
        this.stats = new ConcurrentHashMap<Integer, FlareProtos.WindowStatistics>();
    }

    public void startCountingTicks(TickRoutine hook) {
        this.tickCounter = new NormalTickCounter(this.flare, hook);
    }

    public ExplicitTickCounter startCountingTicksExplicit(TickRoutine hook) {
        ExplicitTickCounter counter = new ExplicitTickCounter(this.flare, hook);
        this.tickCounter = counter;
        return counter;
    }

    public void stop() {
        if (this.tickCounter != null) {
            this.tickCounter.stop();
        }
    }

    public int getTotalTicks() {
        return this.tickCounter == null ? -1 : this.tickCounter.getTotalTicks();
    }

    public void recordWindowStartTime(int window) {
        this.windowStartTimes.put(window, System.currentTimeMillis());
    }

    public void measureNow(int window) {
        this.stats.computeIfAbsent(window, this::measure);
    }

    public void ensureHasStatisticsForAllWindows(int[] windows) {
        for (int window : windows) {
            this.stats.computeIfAbsent(window, w -> ZERO);
        }
    }

    public void pruneStatistics(IntPredicate predicate) {
        this.stats.keySet().removeIf(predicate::test);
    }

    public Map<Integer, FlareProtos.WindowStatistics> export() {
        return this.stats;
    }

    private FlareProtos.WindowStatistics measure(int window) {
        FlareProtos.WindowStatistics.Builder builder = FlareProtos.WindowStatistics.newBuilder();
        long endTime = System.currentTimeMillis();
        Long startTime = this.windowStartTimes.get(window);
        if (startTime == null) {
            this.flare.logger().warn("Unknown start time for window {}", (Object)window);
            startTime = endTime - 10000L;
        }
        builder.setStartTime(startTime);
        builder.setEndTime(endTime);
        builder.setDuration((int)(endTime - startTime));
        TickStatistics tickStatistics = this.flare.tickStatistics(this.side, TickType.ALL);
        if (tickStatistics != null) {
            builder.setTps(tickStatistics.tps1Min());
            DoubleAverageInfo mspt = tickStatistics.duration1Min();
            if (mspt != null) {
                builder.setMsptMedian(mspt.median());
                builder.setMsptMax(mspt.max());
            }
        }
        if (this.tickCounter != null) {
            int ticks = this.tickCounter.getCountedTicksThisWindowAndReset();
            builder.setTicks(ticks);
        }
        builder.setCpuProcess(CpuMonitor.processLoad1MinAvg());
        builder.setCpuSystem(CpuMonitor.systemLoad1MinAvg());
        if (this.flare.server() != null) {
            builder.setPlayers(this.flare.players().size());
            builder.setEntities(this.flare.entities().size());
            builder.setTileEntities(this.flare.tileEntities().size());
            builder.setChunks(this.flare.chunks().size());
        }
        return (FlareProtos.WindowStatistics)builder.build();
    }

    public static final class ExplicitTickCounter
    extends BaseTickCounter {
        private final AtomicInteger counted = new AtomicInteger();
        private final AtomicInteger total = new AtomicInteger();

        ExplicitTickCounter(FlareAPI flare, TickRoutine tickHook) {
            super(flare, tickHook);
        }

        public void increment() {
            this.counted.incrementAndGet();
            this.total.incrementAndGet();
        }

        public int getTotalCountedTicks() {
            return this.total.get();
        }

        @Override
        public int getCountedTicksThisWindowAndReset() {
            return this.counted.getAndSet(0);
        }
    }

    public static final class NormalTickCounter
    extends BaseTickCounter {
        private int last;

        NormalTickCounter(FlareAPI flare, TickRoutine tickHook) {
            super(flare, tickHook);
            this.last = this.tickHook.currentTick();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCountedTicksThisWindowAndReset() {
            NormalTickCounter normalTickCounter = this;
            synchronized (normalTickCounter) {
                int now = this.tickHook.currentTick();
                int ticks = now - this.last;
                this.last = now;
                return ticks;
            }
        }
    }

    private static abstract class BaseTickCounter
    implements TickCounter {
        protected final FlareAPI flare;
        protected final TickRoutine tickHook;
        private final int startTick;
        private int stopTick = -1;

        BaseTickCounter(FlareAPI flare, TickRoutine tickHook) {
            this.flare = flare;
            this.tickHook = tickHook;
            this.startTick = this.tickHook.currentTick();
        }

        @Override
        public void stop() {
            this.stopTick = this.tickHook.currentTick();
        }

        @Override
        public int getTotalTicks() {
            if (this.startTick == -1) {
                throw new IllegalStateException("start tick not recorded");
            }
            int stopTick = this.stopTick;
            if (stopTick == -1) {
                stopTick = this.tickHook.currentTick();
            }
            return stopTick - this.startTick;
        }
    }

    public static interface TickCounter {
        public void stop();

        public int getTotalTicks();

        public int getCountedTicksThisWindowAndReset();
    }
}

