/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.util;

import com.cleanroommc.flare.api.FlareAPI;
import com.cleanroommc.flare.util.LangKeys;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public final class ChatUtil {
    public static final String RAW_PREFIX = TextFormatting.GRAY + "[" + TextFormatting.GOLD + "\u2733" + TextFormatting.GRAY + "]" + TextFormatting.RESET + " ";
    public static final DecimalFormat FLOAT_FORMAT = new DecimalFormat("#.##");

    public static ITextComponent prefix(ITextComponent message) {
        return new TextComponentString(RAW_PREFIX).func_150257_a(message);
    }

    public static void sendMessage(FlareAPI flare, ICommandSender sender, ITextComponent textComponent) {
        textComponent = ChatUtil.prefix(textComponent);
        if (sender == null) {
            flare.logger().warn(textComponent.func_150260_c());
        } else {
            sender.func_145747_a(textComponent);
        }
    }

    public static void sendMessage(FlareAPI flare, ICommandSender sender, LangKeys langKey, Object ... formatArgs) {
        ChatUtil.sendMessage(flare, sender, (ITextComponent)new TextComponentTranslation(langKey.langKey, formatArgs));
    }

    public static void sendMessage(FlareAPI flare, ICommandSender sender, LangKeys langKey, Consumer<TextComponentTranslation> unaryOperator, Object ... formatArgs) {
        TextComponentTranslation text = new TextComponentTranslation(langKey.langKey, formatArgs);
        unaryOperator.accept(text);
        ChatUtil.sendMessage(flare, sender, (ITextComponent)text);
    }

    private ChatUtil() {
    }
}

