/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.util;

import com.cleanroommc.flare.api.sampler.node.MethodDescriptorResolver;
import com.cleanroommc.flare.api.sampler.node.type.StackTraceNode;
import com.cleanroommc.flare.api.util.ClassFinder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class FlareMethodDescriptorResolver
extends MethodDescriptorResolver {
    protected final Map<Class<?>, Map<String, List<MethodNode>>> cache = new Object2ObjectOpenHashMap();

    @Override
    @Nullable
    public String resolve(StackTraceNode node) {
        List<MethodNode> methodNodes;
        if (node.methodDescription() != null) {
            return node.methodDescription();
        }
        String resourceName = node.className().replace('/', '.');
        Class<?> clazz = ClassFinder.findClass(resourceName);
        if (clazz == null) {
            return null;
        }
        Object2ObjectOpenHashMap cachedMethods = this.cache.get(clazz);
        if (cachedMethods == null) {
            cachedMethods = new Object2ObjectOpenHashMap();
            this.cache.put(clazz, (Map<String, List<MethodNode>>)cachedMethods);
            try {
                InputStream is = FlareMethodDescriptorResolver.openInputStreamForClass(clazz, resourceName);
                Object object = null;
                try {
                    if (is != null) {
                        ClassNode classNode = new ClassNode();
                        ClassReader reader = new ClassReader(is);
                        reader.accept((ClassVisitor)classNode, 0);
                        for (MethodNode methodNode : classNode.methods) {
                            cachedMethods.computeIfAbsent(methodNode.name, k -> new ArrayList()).add(methodNode);
                        }
                    }
                }
                catch (Throwable classNode) {
                    object = classNode;
                    throw classNode;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable classNode) {
                                ((Throwable)object).addSuppressed(classNode);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException is) {
                // empty catch block
            }
        }
        if ((methodNodes = cachedMethods.get(node.methodName())) == null) {
            return null;
        }
        for (MethodNode methodNode : methodNodes) {
            for (AbstractInsnNode insnNode : methodNode.instructions) {
                if (!(insnNode instanceof LineNumberNode) || node.lineNumber() != ((LineNumberNode)insnNode).line) continue;
                return methodNode.desc;
            }
        }
        return null;
    }
}

