/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.flare.util;

import java.util.Locale;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public final class FormatUtil {
    private static final String[] SIZE_UNITS = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

    public static String percent(double value, double max) {
        double percent = value * 100.0 / max;
        return (int)percent + "%";
    }

    public static String formatBytes(long bytes) {
        if (bytes <= 0L) {
            return "0 bytes";
        }
        int sizeIndex = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.format(Locale.ENGLISH, "%.1f", (double)bytes / Math.pow(1024.0, sizeIndex)) + " " + SIZE_UNITS[sizeIndex];
    }

    public static ITextComponent formatBytes(long bytes, TextFormatting colour, String suffix) {
        String unit;
        String value;
        if (bytes <= 0L) {
            value = "0";
            unit = "KB" + suffix;
        } else {
            int sizeIndex = (int)(Math.log(bytes) / Math.log(1024.0));
            value = String.format(Locale.ENGLISH, "%.1f", (double)bytes / Math.pow(1024.0, sizeIndex));
            unit = SIZE_UNITS[sizeIndex] + suffix;
        }
        TextComponentString valueText = new TextComponentString(value + " ");
        valueText.func_150256_b().func_150238_a(colour);
        return valueText.func_150257_a((ITextComponent)new TextComponentString(unit));
    }

    public static String formatSeconds(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long second = seconds;
        long minute = second / 60L;
        second %= 60L;
        StringBuilder sb = new StringBuilder();
        if (minute != 0L) {
            sb.append(minute).append("m ");
        }
        if (second != 0L) {
            sb.append(second).append("s ");
        }
        return sb.toString().trim();
    }

    private FormatUtil() {
    }
}

