/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IDatabasePlugin;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.lepidopterology.genetics.ButterflyPlugin;
import forestry.lepidopterology.genetics.FlutterlyzerPlugin;
import forestry.lepidopterology.genetics.LepidopteristTracker;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.lepidopterology.items.ItemRegistryLepidopterology;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ButterflyRoot
extends SpeciesRoot
implements IButterflyRoot {
    private static int butterflySpeciesCount = -1;
    public static final String UID = "rootButterflies";
    private static final List<IButterfly> butterflyTemplates = new ArrayList<IButterfly>();
    private static final List<IButterflyMutation> butterflyMutations = new ArrayList<IButterflyMutation>();

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return IButterfly.class;
    }

    @Override
    public int getSpeciesCount() {
        if (butterflySpeciesCount < 0) {
            butterflySpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleButterflySpecies) || !((IAlleleButterflySpecies)entry.getValue()).isCounted()) continue;
                ++butterflySpeciesCount;
            }
        }
        return butterflySpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return this.getType(stack) != null;
    }

    @Override
    @Nullable
    public EnumFlutterType getType(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemRegistryLepidopterology butterflyItems = ModuleLepidopterology.getItems();
        Preconditions.checkNotNull((Object)butterflyItems);
        Item item = stack.func_77973_b();
        if (butterflyItems.butterflyGE == item) {
            return EnumFlutterType.BUTTERFLY;
        }
        if (butterflyItems.serumGE == item) {
            return EnumFlutterType.SERUM;
        }
        if (butterflyItems.caterpillarGE == item) {
            return EnumFlutterType.CATERPILLAR;
        }
        if (butterflyItems.cocoonGE == item) {
            return EnumFlutterType.COCOON;
        }
        return null;
    }

    @Override
    public EnumFlutterType getIconType() {
        return EnumFlutterType.BUTTERFLY;
    }

    @Override
    public ISpeciesType[] getTypes() {
        return EnumFlutterType.values();
    }

    @Override
    public boolean isMember(ItemStack stack, ISpeciesType type) {
        return this.getType(stack) == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    @Override
    public IButterfly getMember(ItemStack stack) {
        if (!this.isMember(stack) || stack.func_77978_p() == null) {
            return null;
        }
        return new Butterfly(stack.func_77978_p());
    }

    @Override
    public IButterfly getMember(NBTTagCompound compound) {
        return new Butterfly(compound);
    }

    @Override
    public ItemStack getMemberStack(IIndividual butterfly, ISpeciesType type) {
        ItemButterflyGE butterflyItem;
        Preconditions.checkArgument((boolean)(type instanceof EnumFlutterType));
        ItemRegistryLepidopterology items = ModuleLepidopterology.getItems();
        Preconditions.checkNotNull((Object)items);
        switch ((EnumFlutterType)type) {
            case SERUM: {
                butterflyItem = items.serumGE;
                break;
            }
            case CATERPILLAR: {
                butterflyItem = items.caterpillarGE;
                break;
            }
            case COCOON: {
                butterflyItem = items.cocoonGE;
                break;
            }
            default: {
                butterflyItem = items.butterflyGE;
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        butterfly.writeToNBT(nbttagcompound);
        ItemStack stack = new ItemStack((Item)butterflyItem);
        stack.func_77982_d(nbttagcompound);
        if (type == EnumFlutterType.CATERPILLAR) {
            ItemButterflyGE.setAge(stack, 0);
        }
        return stack;
    }

    public EntityButterfly spawnButterflyInWorld(World world, IButterfly butterfly, double x, double y, double z) {
        return EntityUtil.spawnEntity(world, new EntityButterfly(world, butterfly, new BlockPos(x, y, z)), x, y, z);
    }

    @Override
    public BlockPos plantCocoon(World world, BlockPos coordinates, @Nullable IButterfly caterpillar, GameProfile owner, int age, boolean createNursery) {
        if (caterpillar == null) {
            return BlockPos.field_177992_a;
        }
        BlockRegistryLepidopterology blocks = ModuleLepidopterology.getBlocks();
        BlockPos pos = this.getValidCocoonPos(world, coordinates, owner, createNursery);
        if (pos == null) {
            return BlockPos.field_177992_a;
        }
        IBlockState state = blocks.cocoon.func_176223_P();
        boolean placed = world.func_175656_a(pos, state);
        if (!placed) {
            return BlockPos.field_177992_a;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (blocks.cocoon != block) {
            return BlockPos.field_177992_a;
        }
        TileCocoon cocoon = TileUtil.getTile((IBlockAccess)world, pos, TileCocoon.class);
        if (cocoon == null) {
            world.func_175698_g(pos);
            return BlockPos.field_177992_a;
        }
        cocoon.setCaterpillar(caterpillar);
        cocoon.getOwnerHandler().setOwner(owner);
        cocoon.setAge(age);
        return pos;
    }

    @Nullable
    private BlockPos getValidCocoonPos(World world, BlockPos pos, GameProfile gameProfile, boolean createNursery) {
        if (ButterflyRoot.isPositionValid(world, pos.func_177977_b(), gameProfile, createNursery)) {
            return pos.func_177977_b();
        }
        for (int tries = 0; tries < 3; ++tries) {
            for (int y = 1; y < world.field_73012_v.nextInt(5); ++y) {
                BlockPos coordinate = pos.func_177982_a(world.field_73012_v.nextInt(6) - 3, -y, world.field_73012_v.nextInt(6) - 3);
                if (!ButterflyRoot.isPositionValid(world, coordinate, gameProfile, createNursery)) continue;
                return coordinate;
            }
        }
        return null;
    }

    @Deprecated
    public boolean isPositionValid(World world, BlockPos pos, @Nullable IButterfly caterpillar, GameProfile gameProfile, boolean createNursery) {
        return ButterflyRoot.isPositionValid(world, pos, gameProfile, createNursery);
    }

    private static boolean isPositionValid(World world, BlockPos pos, GameProfile gameProfile, boolean createNursery) {
        IBlockState blockState = world.func_180495_p(pos);
        if (BlockUtil.canReplace(blockState, world, pos)) {
            BlockPos nurseryPos = pos.func_177984_a();
            IButterflyNursery nursery = GeneticsUtil.getNursery(world, nurseryPos);
            if (nursery != null) {
                return true;
            }
            if (createNursery && GeneticsUtil.canCreateNursery(world, nurseryPos)) {
                nursery = GeneticsUtil.getOrCreateNursery(gameProfile, world, nurseryPos, false);
                return nursery != null && nursery.getCaterpillar() == null;
            }
        }
        return false;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        IButterfly butterfly = this.getMember(stack);
        return butterfly != null && butterfly.getMate() != null;
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] template) {
        return new Butterfly(this.templateAsGenome(template));
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Butterfly(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] template) {
        return new ButterflyGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new ButterflyGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public List<IButterfly> getIndividualTemplates() {
        return butterflyTemplates;
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return MothDefinition.Brimstone.getTemplate();
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        butterflyTemplates.add(ButterflyManager.butterflyRoot.templateAsIndividual(template));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        butterflyMutations.add((IButterflyMutation)mutation);
    }

    @Override
    public List<IButterflyMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(butterflyMutations);
        }
        return butterflyMutations;
    }

    @Override
    public ILepidopteristTracker getBreedingTracker(World world, @Nullable GameProfile player) {
        String filename = "LepidopteristTracker." + (player == null ? "common" : player.getId());
        LepidopteristTracker tracker = (LepidopteristTracker)world.func_72943_a(LepidopteristTracker.class, filename);
        if (tracker == null) {
            tracker = new LepidopteristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        tracker.setUsername(player);
        tracker.setWorld(world);
        return tracker;
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumButterflyChromosome.values();
    }

    @Override
    public IChromosomeType getSpeciesChromosomeType() {
        return EnumButterflyChromosome.SPECIES;
    }

    @Override
    public IAlyzerPlugin getAlyzerPlugin() {
        return FlutterlyzerPlugin.INSTANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IDatabasePlugin getSpeciesPlugin() {
        return ButterflyPlugin.INSTANCE;
    }
}

