/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianFeather;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.StymphalianBirdFlock;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAIFlee;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAITarget;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.oredict.OreDictionary;

public class EntityStymphalianBird
extends EntityCreature
implements IAnimatedEntity,
IMob,
IVillagerFear,
IAnimalFear {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "stymphalian_bird"));
    protected static final Predicate<Entity> STYMPHALIAN_PREDICATE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityStymphalianBird;
        }
    };
    private static final int FLIGHT_CHANCE_PER_TICK = 100;
    private static final DataParameter<Optional<UUID>> VICTOR_ENTITY = EntityDataManager.func_187226_a(EntityStymphalianBird.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityStymphalianBird.class, (DataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_PECK = Animation.create((int)20);
    public static Animation ANIMATION_SHOOT_ARROWS = Animation.create((int)30);
    public static Animation ANIMATION_SPEAK = Animation.create((int)10);
    public float flyProgress;
    public BlockPos airTarget;
    public StymphalianBirdFlock flock;
    private int animationTick;
    private Animation currentAnimation;
    private EntityLivingBase victorEntity;
    private boolean isFlying;
    private int flyTicks;
    private int launchTicks;
    private boolean aiFlightLaunch = false;
    private int airBorneCounter;

    public EntityStymphalianBird(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.3f, 1.2f);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new StymphalianBirdAIFlee(this, 10.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new StymphalianBirdAIAirTarget(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new StymphalianBirdAITarget<EntityLivingBase>(this, EntityLivingBase.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)Math.min(2048, IceAndFire.CONFIG.stymphalianBirdTargetSearchLength));
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VICTOR_ENTITY, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 10;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.getVictorId() == null) {
            tag.func_74778_a("VictorUUID", "");
        } else {
            tag.func_74778_a("VictorUUID", this.getVictorId().toString());
        }
        tag.func_74757_a("Flying", this.isFlying());
    }

    public void func_70037_a(NBTTagCompound tag) {
        String s;
        super.func_70037_a(tag);
        if (tag.func_150297_b("VictorUUID", 8)) {
            s = tag.func_74779_i("VictorUUID");
        } else {
            String s1 = tag.func_74779_i("Victor");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setVictorId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setFlying(tag.func_74767_n("Flying"));
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            this.setVictorId(cause.func_76346_g().func_110124_au());
            if (this.flock != null) {
                this.flock.setFearTarget((EntityLivingBase)cause.func_76346_g());
            }
        }
        super.func_70645_a(cause);
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K && IceAndFire.CONFIG.stymphalianBirdsOreDictDrops) {
            ItemStack stack;
            NonNullList bronzeItems = OreDictionary.getOres((String)"ingotBronze");
            NonNullList copperItems = OreDictionary.getOres((String)"ingotCopper");
            if (!bronzeItems.isEmpty()) {
                for (ItemStack bronzeIngot : bronzeItems) {
                    if (bronzeIngot == ItemStack.field_190927_a) continue;
                    stack = bronzeIngot.func_77946_l();
                    stack.func_190920_e(1 + this.func_70681_au().nextInt(3));
                    this.dropItemAt(stack, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    break;
                }
            }
            if (!copperItems.isEmpty()) {
                for (ItemStack copperIngot : copperItems) {
                    if (copperIngot == ItemStack.field_190927_a) continue;
                    stack = copperIngot.func_77946_l();
                    stack.func_190920_e(1 + this.func_70681_au().nextInt(3));
                    this.dropItemAt(stack, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    break;
                }
            }
        }
    }

    @Nullable
    private EntityItem dropItemAt(ItemStack stack, double x, double y, double z) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, x, y, z, stack);
        entityitem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    @Nullable
    public UUID getVictorId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(VICTOR_ENTITY)).orNull();
    }

    public void setVictorId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(VICTOR_ENTITY, (Object)Optional.fromNullable((Object)uuid));
    }

    @Nullable
    public EntityLivingBase getVictor() {
        try {
            UUID uuid = this.getVictorId();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void setVictor(EntityLivingBase player) {
        this.setVictorId(player.func_110124_au());
    }

    public boolean isVictor(EntityLivingBase entityIn) {
        return entityIn == this.getVictor();
    }

    public boolean isTargetBlocked(Vec3d target) {
        RayTraceResult rayTrace;
        if (target != null && (rayTrace = this.field_70170_p.func_72901_a(new Vec3d((Vec3i)this.func_180425_c()), target, false)) != null && rayTrace.field_72307_f != null) {
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(pos)) {
                return true;
            }
            return rayTrace != null && rayTrace.field_72313_a != RayTraceResult.Type.BLOCK;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PECK);
        }
        return true;
    }

    public void func_70636_d() {
        boolean flying;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && (this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).func_184812_l_() || this.getVictor() != null && this.isVictor(this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        if (this.flock == null) {
            StymphalianBirdFlock otherFlock = StymphalianBirdFlock.getNearbyFlock(this);
            if (otherFlock == null) {
                this.flock = StymphalianBirdFlock.createFlock(this);
            } else {
                this.flock = otherFlock;
                this.flock.addToFlock(this);
            }
        } else {
            if (!this.flock.isLeader(this)) {
                double dist = this.func_70068_e((Entity)this.flock.getLeader());
                if (dist > 360.0) {
                    this.setFlying(true);
                    this.field_70699_by.func_75499_g();
                    this.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(this.flock.getLeader());
                    this.aiFlightLaunch = false;
                } else if (!this.flock.getLeader().isFlying()) {
                    this.setFlying(false);
                    this.airTarget = null;
                    this.aiFlightLaunch = false;
                }
                if (this.field_70122_E && dist < 40.0 && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
                    this.setFlying(false);
                }
            }
            this.flock.update();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && !this.func_70638_az().field_70128_L) {
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (this.getAnimation() == ANIMATION_PECK && this.getAnimationTick() == 7) {
                if (dist < 1.5) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                }
                if (this.field_70122_E) {
                    this.setFlying(false);
                }
            }
            if (this.getAnimation() != ANIMATION_PECK && this.getAnimation() != ANIMATION_SHOOT_ARROWS && dist > 3.0 && dist < 225.0) {
                this.setAnimation(ANIMATION_SHOOT_ARROWS);
            }
            if (this.getAnimation() == ANIMATION_SHOOT_ARROWS) {
                EntityLivingBase target = this.func_70638_az();
                this.func_70625_a((Entity)target, 360.0f, 360.0f);
                if (this.isFlying()) {
                    this.field_70177_z = this.field_70761_aq;
                    if ((this.getAnimationTick() == 7 || this.getAnimationTick() == 14) && this.isDirectPathBetweenPoints((Entity)this, this.func_174791_d(), target.func_174791_d())) {
                        this.func_184185_a(IafSoundRegistry.STYMPHALIAN_BIRD_ATTACK, 1.0f, 1.0f);
                        for (int i = 0; i < 4; ++i) {
                            float wingX = (float)(this.field_70165_t + (double)0.9f * Math.cos((double)(this.field_70177_z + (float)(180 * (i % 2))) * Math.PI / 180.0));
                            float wingZ = (float)(this.field_70161_v + (double)0.9f * Math.sin((double)(this.field_70177_z + (float)(180 * (i % 2))) * Math.PI / 180.0));
                            float wingY = (float)(this.field_70163_u + 1.0);
                            double d0 = target.field_70165_t - (double)wingX;
                            double d1 = target.func_174813_aQ().field_72338_b - (double)wingY;
                            double d2 = target.field_70161_v - (double)wingZ;
                            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                            EntityStymphalianFeather entityarrow = new EntityStymphalianFeather(this.field_70170_p, (EntityLivingBase)this);
                            entityarrow.func_70107_b(wingX, wingY, wingZ);
                            entityarrow.func_70186_c(d0, d1 + d3 * 0.10000000298023223, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            this.field_70170_p.func_72838_d((Entity)entityarrow);
                        }
                    }
                } else {
                    this.setFlying(true);
                }
            }
        }
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        boolean bl = flying = this.isFlying() && !this.field_70122_E || this.airBorneCounter > 10 || this.getAnimation() == ANIMATION_SHOOT_ARROWS;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.isFlying() && this.airTarget != null && this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.func_70638_az() == null) {
            this.flyAround();
        } else if (this.func_70638_az() != null) {
            this.flyTowardsTarget();
        }
        if (!this.field_70170_p.field_72995_K && this.doesWantToLand() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70038_c(0.0, 0.0, 0.0) && !this.isFlying()) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70122_E && this.isFlying() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if ((properties == null || properties != null && !properties.isStone) && !this.field_70170_p.field_72995_K && (this.flock == null || this.flock != null && this.flock.isLeader(this)) && this.func_70681_au().nextInt(100) == 0 && !this.isFlying() && this.func_184188_bt().isEmpty() && !this.func_70631_g_() && this.field_70122_E) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.aiFlightLaunch && this.launchTicks < 40) {
                ++this.launchTicks;
            } else {
                this.launchTicks = 0;
                this.aiFlightLaunch = false;
            }
            this.flyTicks = this.isFlying() ? ++this.flyTicks : 0;
        }
        this.airBorneCounter = !this.field_70122_E ? ++this.airBorneCounter : 0;
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !this.isFlying() && !this.field_70170_p.field_72995_K) {
            this.setFlying(true);
            this.aiFlightLaunch = true;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.field_70163_u > (double)IceAndFire.CONFIG.stymphalianBirdFlightHeight) {
            this.func_70107_b(this.field_70165_t, IceAndFire.CONFIG.stymphalianBirdFlightHeight, this.field_70161_v);
        }
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = entity.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)entity.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    private boolean isLeaderNotFlying() {
        return this.flock != null && this.flock.getLeader() != null && !this.flock.getLeader().isFlying();
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.field_70165_t;
            targetY = (double)Math.min(this.airTarget.func_177956_o(), 256) + 1.0 - this.field_70163_u;
            targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * (double)this.getFlySpeed(false);
            this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * (double)this.getFlySpeed(true);
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * (double)this.getFlySpeed(false);
            angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70126_B = this.field_70177_z;
            this.field_70177_z += rotation;
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            v1 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
            }
        }
    }

    private float getFlySpeed(boolean y) {
        float speed = 2.0f;
        if (this.flock != null && !this.flock.isLeader(this) && this.func_70068_e((Entity)this.flock.getLeader()) > 10.0) {
            speed = 4.0f;
        }
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !y) {
            speed = (float)((double)speed * 0.05);
        }
        return speed;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.STYMPHALIAN_BIRD_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.STYMPHALIAN_BIRD_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.STYMPHALIAN_BIRD_DIE;
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.isVictor(entity) && entity != null) {
            return;
        }
        super.func_70624_b(entity);
        if (this.flock != null && this.flock.isLeader(this) && entity != null) {
            this.flock.onLeaderAttack(entity);
        }
    }

    public float getDistanceSquared(Vec3d vec3d) {
        float f = (float)(this.field_70165_t - vec3d.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec3d.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec3d.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a);
    }

    public boolean doesWantToLand() {
        if (this.flock != null && !this.flock.isLeader(this) && this.flock.getLeader() != null) {
            return this.flock.getLeader().doesWantToLand();
        }
        return this.flyTicks > 500 || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_PECK, ANIMATION_SHOOT_ARROWS, ANIMATION_SPEAK};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return IceAndFire.CONFIG.stympahlianBirdAttackAnimals;
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

