/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.block.BlockDragonforgeInput;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityDragonforgeInput
extends TileEntity
implements ITickable {
    private static final int LURE_DISTANCE = 50;
    private int ticksSinceDragonFire;
    private TileEntityDragonforge core = null;

    public void onHitWithFlame() {
        TileEntityDragonforge forge = this.getConnectedTileEntity();
        if (forge != null) {
            forge.transferPower(1);
        }
    }

    public void func_73660_a() {
        if (this.core == null) {
            this.core = this.getConnectedTileEntity();
        }
        if (this.ticksSinceDragonFire > 0) {
            --this.ticksSinceDragonFire;
        }
        if ((this.ticksSinceDragonFire == 0 || this.core == null) && this.isActive()) {
            TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, this.getDeactivatedState());
            if (tileentity != null) {
                tileentity.func_145829_t();
                this.field_145850_b.func_175690_a(this.field_174879_c, tileentity);
            }
        }
        this.lureDragons();
    }

    protected void lureDragons() {
        if (this.core != null && this.core.canSmelt()) {
            for (EntityDragonBase dragon : this.field_145850_b.func_72872_a(EntityDragonBase.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 50.0, (double)this.field_174879_c.func_177956_o() - 50.0, (double)this.field_174879_c.func_177952_p() - 50.0, (double)this.field_174879_c.func_177958_n() + 50.0, (double)this.field_174879_c.func_177956_o() + 50.0, (double)this.field_174879_c.func_177952_p() + 50.0))) {
                if (this.isFire() != (dragon.dragonType == DragonType.FIRE) || !dragon.isChained() && !dragon.func_70909_n() || !this.canSeeInput(dragon, new Vec3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f)))) continue;
                dragon.burningTarget = this.field_174879_c;
            }
        } else {
            for (EntityDragonBase dragon : this.field_145850_b.func_72872_a(EntityDragonBase.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 50.0, (double)this.field_174879_c.func_177956_o() - 50.0, (double)this.field_174879_c.func_177952_p() - 50.0, (double)this.field_174879_c.func_177958_n() + 50.0, (double)this.field_174879_c.func_177956_o() + 50.0, (double)this.field_174879_c.func_177952_p() + 50.0))) {
                if (dragon.burningTarget != this.field_174879_c) continue;
                dragon.burningTarget = null;
                dragon.setBreathingFire(false);
            }
        }
    }

    public void resetCore() {
        this.core = null;
    }

    private boolean canSeeInput(EntityDragonBase dragon, Vec3d target) {
        RayTraceResult rayTrace;
        if (target != null && (rayTrace = this.field_145850_b.func_72901_a(new Vec3d((Vec3i)dragon.func_180425_c().func_177981_b((int)dragon.field_70131_O)), target, false)) != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof BlockDragonforgeInput || this.field_145850_b.func_180495_p(sidePos).func_177230_c() instanceof BlockDragonforgeInput;
        }
        return false;
    }

    private IBlockState getDeactivatedState() {
        return this.isFire() ? IafBlockRegistry.dragonforge_fire_input.func_176223_P().func_177226_a((IProperty)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false)) : IafBlockRegistry.dragonforge_ice_input.func_176223_P().func_177226_a((IProperty)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    private boolean isFire() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == IafBlockRegistry.dragonforge_fire_input;
    }

    private boolean isActive() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockDragonforgeInput && (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDragonforgeInput.ACTIVE) != false;
    }

    private void setActive() {
        TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, this.getDeactivatedState().func_177226_a((IProperty)BlockDragonforgeInput.ACTIVE, (Comparable)Boolean.valueOf(true)));
        if (tileentity != null) {
            tileentity.func_145829_t();
            this.field_145850_b.func_175690_a(this.field_174879_c, tileentity);
        }
    }

    private TileEntityDragonforge getConnectedTileEntity() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) == null || !(this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) instanceof TileEntityDragonforge)) continue;
            return (TileEntityDragonforge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getConnectedTileEntity() != null && this.getConnectedTileEntity().hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.getConnectedTileEntity() != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getConnectedTileEntity().getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

