/*
 * Decompiled with CFR 0.152.
 */
package zzzank.mod.jei_area_fixer.debug;

import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import zzzank.mod.jei_area_fixer.JEIAreaFixerConfig;
import zzzank.mod.jei_area_fixer.debug.JEIAreaFixerDebug;
import zzzank.mod.jei_area_fixer.utils.ScheduledTaskThread;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="jei_area_fixer")
public class JEIAreaFixerDebugAction {
    public static final ScheduledTaskThread messageSender = new ScheduledTaskThread("jei_area_fixer scheduled print", 3000L, JEIAreaFixerDebugAction::print);
    private static final Map<Class<? extends GuiContainer>, List<Rectangle>> lastBounds = new IdentityHashMap<Class<? extends GuiContainer>, List<Rectangle>>();

    public static void print() {
        if (!JEIAreaFixerConfig.DEBUG.print || JEIAreaFixerDebug.boundsMap.isEmpty()) {
            return;
        }
        StringJoiner joiner = new StringJoiner("\n");
        for (Map.Entry<Class<? extends GuiContainer>, List<Rectangle>> e : JEIAreaFixerDebug.boundsMap.entrySet()) {
            Class<? extends GuiContainer> key = e.getKey();
            List<Rectangle> value = e.getValue();
            if (value.equals(lastBounds.get(key))) continue;
            lastBounds.put(key, value);
            joiner.add(String.format("class '%s' with new bounds: %s", e.getKey(), e.getValue().stream().map(bound -> "[x: " + bound.x + ", y: " + bound.y + ", width: " + bound.width + ", height: " + bound.height + "]").collect(Collectors.joining(", "))));
        }
        if (joiner.length() == 0) {
            return;
        }
        System.out.println("debug output from JEI Area Fixer\n" + joiner);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void drawing(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!JEIAreaFixerConfig.DEBUG.draw || !(event.getGui() instanceof GuiContainer)) {
            return;
        }
        GuiContainer guiContainer = (GuiContainer)event.getGui();
        if (!JEIAreaFixerConfig.DEBUG.drawAll) {
            JEIAreaFixerDebug.capturedAreas = JEIAreaFixerDebug.collectActiveBounds(guiContainer.getClass());
        }
        for (Rectangle area : JEIAreaFixerDebug.capturedAreas) {
            Gui.func_73734_a((int)area.x, (int)area.y, (int)(area.x + area.width), (int)(area.y + area.height), (int)2134993377);
        }
    }

    static {
        messageSender.setDaemon(true);
        messageSender.start();
    }
}

