/*
 * Decompiled with CFR 0.152.
 */
package zzzank.mod.jei_area_fixer.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import zzzank.mod.jei_area_fixer.JEIAreaFixer;
import zzzank.mod.jei_area_fixer.utils.NameUtils;

@Mod.EventBusSubscriber(modid="jei_area_fixer")
public final class ConfigClassScanner {
    public static final boolean ENABLE_SCAN = false;

    static void scan(@Nonnull Config anno, @Nonnull Class<?> clazz) {
        String prefix = anno.modid() + "." + (anno.category().isEmpty() ? "" : anno.category() + ".");
        try {
            ConfigClassScanner.scanImpl(clazz, null, prefix);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    static void print(String key, Field field) {
        JEIAreaFixer.LOGGER.info("{}={}", (Object)key, (Object)NameUtils.titleToSplitTitle(Modifier.isFinal(field.getModifiers()) ? field.getName().toLowerCase(Locale.ROOT) : field.getName()));
        JEIAreaFixer.LOGGER.info("{}.tooltip={}", (Object)key, (Object)(field.isAnnotationPresent(Config.Comment.class) ? Arrays.stream(field.getAnnotation(Config.Comment.class).value()).collect(Collectors.joining("\\n")) : "Unresolved"));
    }

    static void scanImpl(Class<?> clazz, Object instance, String prefix) throws IllegalAccessException {
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) != (instance == null)) continue;
            String sub = prefix + field.getName().toLowerCase(Locale.ROOT);
            ConfigClassScanner.print(sub, field);
            Class<?> type = field.getType();
            if (!type.getSimpleName().startsWith("_")) continue;
            ConfigClassScanner.scanImpl(type, field.get(instance), sub + ".");
        }
    }

    @SubscribeEvent
    public static void captureCategoryLangkeys(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer) || !event.getWorld().field_72995_K) {
            return;
        }
    }
}

