/*
 * Decompiled with CFR 0.152.
 */
package zzzank.mod.jei_area_fixer;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.Generated;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import zzzank.mod.jei_area_fixer.JEIAreaFixerConfig;
import zzzank.mod.jei_area_fixer.mods.GeneralButtonsArea;
import zzzank.mod.jei_area_fixer.mods.ModState;
import zzzank.mod.jei_area_fixer.mods.ae2wtlib.AE2WTLibButtonsArea;
import zzzank.mod.jei_area_fixer.mods.applied_energistics_2.AE2ButtonsArea;
import zzzank.mod.jei_area_fixer.mods.applied_energistics_2.AE2CellViewArea;
import zzzank.mod.jei_area_fixer.mods.blue_skies.BlueSkiesTabArea;
import zzzank.mod.jei_area_fixer.mods.computer_craft.ComputerScreenArea;
import zzzank.mod.jei_area_fixer.mods.crafting_tweaks.CraftingTweaksButtonArea;
import zzzank.mod.jei_area_fixer.mods.cyclic.ExtendedArmorInventoryArea;
import zzzank.mod.jei_area_fixer.mods.deep_mob_learning.SimulationChamberArea;
import zzzank.mod.jei_area_fixer.mods.deep_mob_learning.TrialKeystoneArea;
import zzzank.mod.jei_area_fixer.mods.dme.DMERedstoneModeButtonArea;
import zzzank.mod.jei_area_fixer.mods.dme.DMESimulationChamberArea;
import zzzank.mod.jei_area_fixer.mods.dme.DMETrialKeystoneArea;
import zzzank.mod.jei_area_fixer.mods.extrautils2.ExtraUtils2DynamicGuiArea;
import zzzank.mod.jei_area_fixer.mods.forestry.ForestryLedgersArea;
import zzzank.mod.jei_area_fixer.mods.gambling_style.GuiVillagerArea;
import zzzank.mod.jei_area_fixer.mods.mcjty_lib.GenericGuiContainerArea;
import zzzank.mod.jei_area_fixer.mods.mrtjpcore.NodeGuiArea;
import zzzank.mod.jei_area_fixer.mods.open_mods.OpenModsSeriesGuiArea;
import zzzank.mod.jei_area_fixer.mods.quark.ChestButtonsArea;
import zzzank.mod.jei_area_fixer.mods.reskillable.ReskillableTabArea;
import zzzank.mod.jei_area_fixer.mods.rftools.ModularStorageArea;
import zzzank.mod.jei_area_fixer.mods.rftools.StorageScannerArea;
import zzzank.mod.jei_area_fixer.mods.smeltery_io.CastingMachineArea;
import zzzank.mod.jei_area_fixer.mods.smeltery_io.FuelControllerArea;
import zzzank.mod.jei_area_fixer.mods.thaumcraft.FocalManipulatorArea;
import zzzank.mod.jei_area_fixer.mods.tinker_io.TinkerIOFuelInputMachineArea;
import zzzank.mod.jei_area_fixer.mods.tinker_io.TinkerIOSmartOutputArea;
import zzzank.mod.jei_area_fixer.mods.trinkets_and_baubles.TrinketGuiArea;
import zzzank.mod.jei_area_fixer.mods.trinkets_and_baubles.TrinketGuiButtonArea;
import zzzank.mod.jei_area_fixer.mods.wct.WirelessCraftingAdditionalArea;

@JEIPlugin
public class JEIAreaFixerJEIPlugin
implements IModPlugin {
    public void register(@Nonnull IModRegistry registry) {
        GuiHandlersRegistryHelper handlers = new GuiHandlersRegistryHelper(registry);
        if (JEIAreaFixerConfig.GENERAL.aggressiveButtonCapture) {
            GeneralButtonsArea buttonsArea = new GeneralButtonsArea();
            handlers.add(buttonsArea);
            MinecraftForge.EVENT_BUS.register((Object)buttonsArea);
        }
        if (ModState.RF_TOOLS && JEIAreaFixerConfig.RF_TOOLS.all) {
            handlers.addIf(JEIAreaFixerConfig.RF_TOOLS.modularStorage, ModularStorageArea::new);
            handlers.addIf(JEIAreaFixerConfig.RF_TOOLS.storageScanner, StorageScannerArea::new);
        }
        if (ModState.GAMBLING_STYLE && JEIAreaFixerConfig.GAMBLING_STYLE.all) {
            handlers.add(new GuiVillagerArea());
        }
        if (ModState.OPEN_MODS_LIB && JEIAreaFixerConfig.OPEN_MODS.all) {
            handlers.add(new OpenModsSeriesGuiArea());
        }
        if (ModState.SMELTERY_IO && JEIAreaFixerConfig.SMELTERY_IO.all) {
            handlers.addIf(JEIAreaFixerConfig.SMELTERY_IO.castingMachine, FuelControllerArea::new);
            handlers.addIf(JEIAreaFixerConfig.SMELTERY_IO.fuelController, CastingMachineArea::new);
        }
        if (ModState.RESKILLABLE) {
            handlers.addIf(JEIAreaFixerConfig.RESKILLABLE.tabs, ReskillableTabArea::new);
        }
        if (ModState.QUARK) {
            handlers.addIf(JEIAreaFixerConfig.QUARK.chestButtons, ChestButtonsArea::new);
        }
        if (ModState.FORESTRY) {
            handlers.addIf(JEIAreaFixerConfig.FORESTRY.tabs, ForestryLedgersArea::new);
        }
        if (ModState.CYCLIC) {
            handlers.addIf(JEIAreaFixerConfig.CYCLIC.extendedInventory, ExtendedArmorInventoryArea::new);
        }
        if (ModState.MCJTY_LIB) {
            handlers.addIf(JEIAreaFixerConfig.MCJTY_LIB.all, GenericGuiContainerArea::new);
        }
        if (ModState.COMPUTER_CRAFT) {
            handlers.addIf(JEIAreaFixerConfig.COMPUTER_CRAFT.computer, ComputerScreenArea::new);
        }
        if (ModState.AE2 && JEIAreaFixerJEIPlugin.shouldEnableForAE2()) {
            handlers.addIf(JEIAreaFixerConfig.AE2.buttons, AE2ButtonsArea::new);
            handlers.addIf(JEIAreaFixerConfig.AE2.cellView, AE2CellViewArea::new);
        }
        if (ModState.TINKER_IO && JEIAreaFixerConfig.TINKER_IO.all) {
            handlers.addIf(JEIAreaFixerConfig.TINKER_IO.fuelInput, TinkerIOFuelInputMachineArea::new);
            handlers.addIf(JEIAreaFixerConfig.TINKER_IO.smartOutput, TinkerIOSmartOutputArea::new);
        }
        if (ModState.BLUE_SKIES) {
            handlers.addIf(JEIAreaFixerConfig.BLUE_SKIES.tabs, BlueSkiesTabArea::new);
        }
        if (ModState.CRAFTING_TWEAKS) {
            handlers.addIf(JEIAreaFixerConfig.CRAFTING_TWEAKS.buttons, CraftingTweaksButtonArea::new);
        }
        if (ModState.TRINKETS_AND_BAUBLES) {
            handlers.addIf(JEIAreaFixerConfig.TRINKETS_AND_BAUBLES.buttons, TrinketGuiButtonArea::new);
            handlers.addIf(JEIAreaFixerConfig.TRINKETS_AND_BAUBLES.slots, TrinketGuiArea::new);
        }
        if (ModState.AE2WT_LIB) {
            handlers.addIf(JEIAreaFixerConfig.AE2WTLIB.buttons, AE2WTLibButtonsArea::new);
        }
        if (ModState.WIRELESS_CRAFTING_TERMINAL) {
            handlers.addIf(JEIAreaFixerConfig.AE2WTLIB.wirelessCraftingTerminal, WirelessCraftingAdditionalArea::new);
        }
        if (ModState.DEEP_MOD_LEARNING) {
            if ("Deep Mob Learning".equals(((ModContainer)Loader.instance().getIndexedModList().get("deepmoblearning")).getName())) {
                handlers.addIf(JEIAreaFixerConfig.DEEP_MOB_LEARNING.simulationChamber, SimulationChamberArea::new);
                handlers.addIf(JEIAreaFixerConfig.DEEP_MOB_LEARNING.trialKeystone, TrialKeystoneArea::new);
            } else {
                handlers.addIf(JEIAreaFixerConfig.DEEP_MOB_LEARNING.buttons, DMERedstoneModeButtonArea::new);
                handlers.addIf(JEIAreaFixerConfig.DEEP_MOB_LEARNING.simulationChamber, DMESimulationChamberArea::new);
                handlers.addIf(JEIAreaFixerConfig.DEEP_MOB_LEARNING.trialKeystone, DMETrialKeystoneArea::new);
            }
        }
        if (ModState.THAUMCRAFT) {
            handlers.addIf(JEIAreaFixerConfig.THAUMCRAFT.focalManipulator, FocalManipulatorArea::new);
        }
        if (ModState.EXTRA_UTILS_2) {
            handlers.addIf(JEIAreaFixerConfig.EXTRA_UTILS_2.widgets, ExtraUtils2DynamicGuiArea::new);
        }
        if (ModState.MRTJPCORE) {
            handlers.addIf(JEIAreaFixerConfig.MRTJP_CORE.nodeGui, NodeGuiArea::new);
        }
    }

    private static boolean shouldEnableForAE2() {
        ModContainer ae2 = (ModContainer)Loader.instance().getIndexedModList().get("appliedenergistics2");
        if (ae2 == null) {
            return false;
        }
        if (JEIAreaFixerConfig.AE2.detectAE2UEL && ae2.getVersion().startsWith("v")) {
            return false;
        }
        return JEIAreaFixerConfig.AE2.all;
    }

    public static class GuiHandlersRegistryHelper {
        private final IModRegistry registry;

        public void add(IAdvancedGuiHandler<?> ... handlers) {
            this.registry.addAdvancedGuiHandlers(handlers);
        }

        public <T extends IAdvancedGuiHandler<?>> T addIf(boolean condition, @Nonnull Supplier<T> handler) {
            if (condition) {
                IAdvancedGuiHandler got = (IAdvancedGuiHandler)handler.get();
                this.add(got);
                return (T)got;
            }
            return null;
        }

        @Generated
        public GuiHandlersRegistryHelper(IModRegistry registry) {
            this.registry = registry;
        }
    }
}

