/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import ua.myxazaur.lemonskin.LemonSkin;

@Config(modid="lemonskin")
public class ModConfig {
    @Config.Name(value="client")
    @Config.Comment(value={"These config settings are client-side only"})
    public static ClientCategory CLIENT = new ClientCategory();

    public static RGB fromHex(String hex) {
        if (hex == null) {
            return new RGB(1.0f, 1.0f, 1.0f);
        }
        try {
            String cleanHex = hex.trim();
            if (cleanHex.startsWith("#")) {
                cleanHex = cleanHex.substring(1);
            }
            if (cleanHex.length() != 6) {
                return new RGB(1.0f, 1.0f, 1.0f);
            }
            int r = Integer.parseInt(cleanHex.substring(0, 2), 16);
            int g = Integer.parseInt(cleanHex.substring(2, 4), 16);
            int b = Integer.parseInt(cleanHex.substring(4, 6), 16);
            return new RGB((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        }
        catch (Exception e) {
            return new RGB(1.0f, 1.0f, 1.0f);
        }
    }

    @Mod.EventBusSubscriber(modid="lemonskin")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("lemonskin")) {
                ConfigManager.sync((String)"lemonskin", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class RGB {
        private final float red;
        private final float green;
        private final float blue;

        public RGB(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }
    }

    public static class ClientCategory {
        @Config.Name(value="Use Modern Tooltip Rendering")
        @Config.LangKey(value="use.modern.tooltip")
        @Config.Comment(value={"true  \u2013 draw bars directly inside the tooltip\nfalse \u2013 draw on a separate floating background (legacy)"})
        public boolean USE_MODERN_TOOLTIP = true;
        @Config.Name(value="Show Food Values in Tooltip")
        @Config.LangKey(value="show.food.values.in.tooltip")
        @Config.Comment(value={"If true, shows the hunger and saturation values of food in its tooltip while holding SHIFT"})
        public boolean SHOW_FOOD_VALUES_IN_TOOLTIP = false;
        @Config.Name(value="Show Food Values in Tooltip Always")
        @Config.LangKey(value="show.food.values.in.tooltip.always")
        @Config.Comment(value={"If true, shows the hunger and saturation values of food in its tooltip automatically (without needing to hold SHIFT)"})
        public boolean ALWAYS_SHOW_FOOD_VALUES_TOOLTIP = true;
        @Config.Name(value="Show Saturation HUD Overlay")
        @Config.LangKey(value="show.saturation.hud.overlay")
        @Config.Comment(value={"If true, shows your current saturation level overlayed on the hunger bar"})
        public boolean SHOW_SATURATION_OVERLAY = true;
        @Config.Name(value="Show Food Values HUD Overlay")
        @Config.LangKey(value="show.food.values.hud.overlay")
        @Config.Comment(value={"If true, shows the hunger (and saturation if show.saturation.hud.overlay is true) that would be restored by food you are currently holding"})
        public boolean SHOW_FOOD_VALUES_OVERLAY = true;
        @Config.Name(value="Show Exhaustion HUD Underlay")
        @Config.LangKey(value="show.food.exhaustion.hud.underlay")
        @Config.Comment(value={"If true, shows your food exhaustion as a progress bar behind the hunger bars"})
        public boolean SHOW_FOOD_EXHAUSTION_UNDERLAY = true;
        @Config.Name(value="Show Food Health HUD Overlay")
        @Config.LangKey(value="show.food.health.hud.overlay")
        @Config.Comment(value={"SHOW_FOOD_HEALTH_HUD_OVERLAY"})
        public boolean SHOW_FOOD_HEALTH_HUD_OVERLAY = false;
        @Config.Name(value="Show Vanilla Animations Overlay")
        @Config.LangKey(value="show.vanilla.animations.overlay")
        @Config.Comment(value={"If true, hunger/health overlay will shake to match Minecraft's icon animations"})
        public boolean SHOW_VANILLA_ANIMATION_OVERLAY = true;
        @Config.Name(value="Show Food Stats in F3")
        @Config.LangKey(value="show.food.stats.in.debug.overlay")
        @Config.Comment(value={"If true, adds a line that shows your hunger, saturation, and exhaustion level in the F3 debug overlay"})
        public boolean SHOW_FOOD_DEBUG_INFO = true;
        @Config.Name(value="Custom Saturation Color")
        @Config.LangKey(value="custom.saturation.color")
        @Config.Comment(value={"Set a custom color for the saturation HUD/Tooltip overlay using hex color code"})
        public String CUSTOM_COLOR = "#FFDF00";
        @Config.Name(value="Use Custom Saturation Color")
        @Config.LangKey(value="use.custom.saturation.color")
        @Config.Comment(value={"Enable to use the custom saturation color instead of default"})
        public boolean USE_CUSTOM_COLOR = false;
        @Config.Name(value="Recipe Book Tooltip fix")
        @Config.Comment(value={"Apply a small fix in the recipe book, necessary for the correct display of tooltips for modern tooltip mode"})
        @Config.RequiresMcRestart
        public boolean RECIPE_BOOK_TOOLTIP_FIX = true;
        @Config.Name(value="Update Overlays When Game Is Paused")
        @Config.LangKey(value="update.overlay.pause")
        @Config.Comment(value={"If true, HUD overlays animations will be updated when the game is paused"})
        public boolean UPDATE_OVERLAY_ON_PAUSE = false;

        public RGB getColor() {
            return this.USE_CUSTOM_COLOR ? ModConfig.fromHex(this.CUSTOM_COLOR) : new RGB(1.0f, 1.0f, 1.0f);
        }

        public ResourceLocation getIcons() {
            return this.USE_CUSTOM_COLOR ? LemonSkin.grayIcons : new ResourceLocation("lemonskin", "textures/icons.png");
        }
    }
}

