/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ua.myxazaur.lemonskin.ModConfig;
import ua.myxazaur.lemonskin.helpers.HungerHelper;

@SideOnly(value=Side.CLIENT)
public final class HUDOverlayRenderer {
    @Deprecated
    private static final int updateCounter = 0;

    @Deprecated
    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, int left, int top, float alpha) {
        HUDOverlayRenderer.drawSaturationOverlay(saturationGained, saturationLevel, mc, left, top, alpha, 0);
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, Minecraft mc, int left, int top, float alpha, int _updateCounter) {
        boolean shouldShake;
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        ModConfig.RGB color = ModConfig.CLIENT.getColor();
        int startBar = saturationGained != 0.0f ? Math.max(0, (int)saturationLevel / 2) : 0;
        int endBar = (int)Math.ceil(Math.min(20.0f, saturationLevel + saturationGained) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.func_110434_K().func_110577_a(ModConfig.CLIENT.getIcons());
        Random rand = new Random((long)_updateCounter * 312871L);
        boolean bl = shouldShake = mc.field_71439_g.func_71024_bL().func_75115_e() <= 0.0f && _updateCounter % (mc.field_71439_g.func_71024_bL().func_75116_a() * 3 + 1) == 0 && ModConfig.CLIENT.SHOW_VANILLA_ANIMATION_OVERLAY;
        if (shouldShake) {
            for (int j = 0; j < startBar; ++j) {
                rand.nextInt(3);
            }
        }
        HUDOverlayRenderer.enableAlpha(alpha);
        GlStateManager.func_179131_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)alpha);
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int x = left - i * 8 - 9;
            int y = shouldShake ? top + (rand.nextInt(3) - 1) : top;
            float effective = (saturationLevel + saturationGained) / 2.0f - (float)i;
            int u = effective >= 1.0f ? 27 : ((double)effective > 0.5 ? 18 : ((double)effective > 0.25 ? 9 : 0));
            mc.field_71456_v.func_73729_b(x, y, u, 0, 9, 9);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        HUDOverlayRenderer.disableAlpha(alpha);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    @Deprecated
    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, int left, int top, float alpha, boolean isRotten) {
        HUDOverlayRenderer.drawHungerOverlay(hungerRestored, foodLevel, mc, left, top, alpha, isRotten, 0);
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, Minecraft mc, int left, int top, float alpha, boolean isRotten, int _updateCounter) {
        boolean shouldShake;
        if (hungerRestored == 0) {
            return;
        }
        int startBar = foodLevel / 2;
        int endBar = (int)Math.ceil((float)Math.min(20, foodLevel + hungerRestored) / 2.0f);
        int barsNeeded = endBar - startBar;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        HUDOverlayRenderer.enableAlpha(alpha);
        Random rand = new Random((long)_updateCounter * 312871L);
        boolean bl = shouldShake = mc.field_71439_g.func_71024_bL().func_75115_e() <= 0.0f && _updateCounter % (foodLevel * 3 + 1) == 0 && ModConfig.CLIENT.SHOW_VANILLA_ANIMATION_OVERLAY;
        if (shouldShake) {
            for (int j = 0; j < startBar; ++j) {
                rand.nextInt(3);
            }
        }
        for (int i = startBar; i < startBar + barsNeeded; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = shouldShake ? top + (rand.nextInt(3) - 1) : top;
            int icon = 16;
            int background = 0;
            if (mc.field_71439_g.func_70644_a(MobEffects.field_76438_s) || isRotten) {
                icon += 36;
                background = 13;
            }
            mc.field_71456_v.func_73729_b(x, y, 16 + background * 9, 27, 9, 9);
            if (idx < foodLevel + hungerRestored) {
                mc.field_71456_v.func_73729_b(x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != foodLevel + hungerRestored) continue;
            mc.field_71456_v.func_73729_b(x, y, icon + 45, 27, 9, 9);
        }
        HUDOverlayRenderer.disableAlpha(alpha);
    }

    @Deprecated
    public static void drawHealthOverlay(float current, float modified, Minecraft mc, int left, int top, float alpha) {
        HUDOverlayRenderer.drawHealthOverlay(current, modified, mc, left, top, alpha, 0);
    }

    public static void drawHealthOverlay(float current, float modified, Minecraft mc, int left, int top, float alpha, int _updateCounter) {
        if (modified <= current) {
            return;
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        EntityPlayerSP player = mc.field_71439_g;
        int healthTarget = MathHelper.func_76123_f((float)modified);
        boolean hardcore = mc.field_71441_e.func_72912_H().func_76093_s();
        int topOffset = hardcore ? 45 : 0;
        int margin = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            margin += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            margin += 72;
        }
        HUDOverlayRenderer.enableAlpha(alpha);
        int start = (int)Math.max(0.0, Math.ceil(current) / 2.0);
        int end = (int)Math.max(0.0, Math.ceil(modified / 2.0f));
        float healthMax = player.func_110138_aP();
        float absorb = player.func_110139_bj();
        int healthBars = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f));
        int healthRows = MathHelper.func_76123_f((float)((float)healthBars / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        boolean shouldShake = current <= 4.0f && ModConfig.CLIENT.SHOW_VANILLA_ANIMATION_OVERLAY;
        for (int i = start; i < end; ++i) {
            int rowIndex = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
            int x = left + i % 10 * 8;
            int y = top - rowIndex * rowHeight;
            if (shouldShake) {
                Random rand = new Random((long)_updateCounter * 312871L);
                int skips = healthBars - 1 - i;
                for (int j = 0; j < skips; ++j) {
                    rand.nextInt(2);
                }
                y += rand.nextInt(2);
            }
            mc.field_71456_v.func_73729_b(x, y, 16, topOffset, 9, 9);
            boolean isHalf = i * 2 + 1 == healthTarget;
            int u = isHalf ? margin + 45 : margin + 36;
            mc.field_71456_v.func_73729_b(x, y, u, topOffset, 9, 9);
        }
        HUDOverlayRenderer.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(float exhaustion, Minecraft mc, int left, int top, float alpha) {
        mc.func_110434_K().func_110577_a(ModConfig.CLIENT.getIcons());
        float maxExhaustion = HungerHelper.getMaxExhaustion((EntityPlayer)mc.field_71439_g);
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        HUDOverlayRenderer.enableAlpha(0.75f);
        mc.field_71456_v.func_73729_b(left - width, top, 81 - width, 18, width, 9);
        HUDOverlayRenderer.disableAlpha(0.75f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static boolean shouldShowEstimatedHealth(EntityPlayer player) {
        if (!ModConfig.CLIENT.SHOW_FOOD_HEALTH_HUD_OVERLAY) {
            return false;
        }
        if (player.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        FoodStats stats = player.func_71024_bL();
        if (stats.func_75116_a() >= 18) {
            return false;
        }
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            return false;
        }
        if (player.func_70644_a(MobEffects.field_82731_v)) {
            return false;
        }
        return !player.func_70644_a(MobEffects.field_76428_l);
    }

    private static void enableAlpha(float alpha) {
        GlStateManager.func_179147_l();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private static void disableAlpha(float alpha) {
        GlStateManager.func_179084_k();
        if (alpha == 1.0f) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

